/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.flytre.flytre_lib.api.config.ConfigEventAcceptor;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.flytre.flytre_lib.impl.config.client.ConfigListWidget;
import net.flytre.flytre_lib.impl.config.client.GenericConfigScreen;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class IndividualConfigScreen<T>
extends GenericConfigScreen {
    private final ConfigHandler<T> handler;
    private final List<ConfigListWidget.ConfigEntry> entries;
    private ConfigListWidget list;

    public IndividualConfigScreen(@Nullable Screen parent, @Nullable Button reopen, ConfigHandler<T> handler) {
        super(parent, reopen);
        this.handler = handler;
        this.entries = new ArrayList<ConfigListWidget.ConfigEntry>();
    }

    public ConfigListWidget getList() {
        return this.list;
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    @Override
    public void onClose() {
        this.handler.save(this.handler.getConfig());
        if (this.handler.getConfig() instanceof ConfigEventAcceptor) {
            ((ConfigEventAcceptor)this.handler.getConfig()).onReload();
        }
        super.onClose();
    }

    public void addEntry(ConfigListWidget.ConfigEntry entry) {
        this.entries.add(entry);
    }

    public List<ConfigListWidget.ConfigEntry> getEntries() {
        return this.entries;
    }

    protected void m_7856_() {
        this.list = new ConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 60, this.f_96544_ - 60, 30);
        this.entries.forEach(i -> this.list.addConfigEntry((ConfigListWidget.ConfigEntry)((Object)i)));
        this.m_142416_((GuiEventListener)this.list);
        super.m_7856_();
        TranslucentButton fileOpener = new TranslucentButton(this.f_96543_ / 2 - this.f_96543_ / 10, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent("flytre_lib.gui.open_file"), button -> {
            Path location = LoaderProperties.getModConfigDirectory();
            Path path = Paths.get(location.toString(), this.handler.getName() + ".json5");
            Util.m_137581_().m_137648_(path.toFile().toURI());
        });
        TranslucentButton helpMac = new TranslucentButton(this.f_96543_ / 2 - this.f_96543_ / 5 - this.f_96543_ / 5, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent("flytre_lib.gui.help_mac"), button -> {
            try {
                Util.m_137581_().m_137648_(new URI("https://support.apple.com/guide/mac-help/choose-an-app-to-open-a-file-on-mac-mh35597/mac"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        });
        TranslucentButton helpWindows = new TranslucentButton(this.f_96543_ / 2 + this.f_96543_ / 5, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent("flytre_lib.gui.help_windows"), button -> {
            try {
                Util.m_137581_().m_137648_(new URI("https://support.microsoft.com/en-us/windows/change-default-programs-in-windows-10-e5d82cad-17d1-c53b-3505-f10a32e1894d"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        });
        this.m_142416_((GuiEventListener)fileOpener);
        this.m_142416_((GuiEventListener)helpMac);
        this.m_142416_((GuiEventListener)helpWindows);
    }
}

