/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.impl.config.client.ConfigStyleList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class GenericConfigScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("flytre_lib:textures/gui/config/background.png");
    @Nullable
    protected final Screen parent;
    @Nullable
    protected final Button reopen;
    private float animationTime;

    public GenericConfigScreen(@Nullable Screen parent, @Nullable Button reopen) {
        super((Component)new TranslatableComponent("flytre_lib.gui.config_screen"));
        this.parent = parent;
        this.reopen = reopen;
    }

    public static void tile(Rectangle bounds, int vOffset, float saturation, int green) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)bounds.getLeft(), (double)bounds.getBottom(), 0.0).m_7421_(0.0f, (float)bounds.getHeight() / 32.0f + (float)vOffset).m_6122_((int)(92.0f * saturation), green, (int)(92.0f * saturation), 255).m_5752_();
        bufferBuilder.m_5483_((double)bounds.getRight(), (double)bounds.getBottom(), 0.0).m_7421_((float)bounds.getWidth() / 32.0f, (float)bounds.getHeight() / 32.0f + (float)vOffset).m_6122_((int)(92.0f * saturation), green, (int)(92.0f * saturation), 255).m_5752_();
        bufferBuilder.m_5483_((double)bounds.getRight(), (double)bounds.getTop(), 0.0).m_7421_((float)bounds.getWidth() / 32.0f, (float)vOffset).m_6122_((int)(92.0f * saturation), (int)(92.0f * saturation), (int)(92.0f * saturation), 255).m_5752_();
        bufferBuilder.m_5483_((double)bounds.getLeft(), (double)bounds.getTop(), 0.0).m_7421_(0.0f, (float)vOffset).m_6122_((int)(92.0f * saturation), (int)(92.0f * saturation), (int)(92.0f * saturation), 255).m_5752_();
        tessellator.m_85914_();
    }

    public void reopenAction() {
        if (this.reopen != null) {
            this.reopen.m_5691_();
        }
        assert (this.f_96541_ != null);
        if (this.f_96541_.f_91080_ != this && this.f_96541_.f_91080_ instanceof GenericConfigScreen) {
            GenericConfigScreen scr = (GenericConfigScreen)this.f_96541_.f_91080_;
            scr.disableAnimation();
            scr.getList().m_93410_(this.getList().m_93517_());
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void onClose() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.animationTime += delta * 0.5f;
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public GenericConfigScreen disableAnimation() {
        this.animationTime = 100.0f;
        return this;
    }

    public void m_96626_(int vOffset) {
        float rawTime = this.animationTime / 0.5f;
        float saturation = rawTime * 0.05f;
        if (saturation > 1.0f) {
            saturation = 1.0f;
        }
        saturation *= saturation;
        int green = Mth.m_14045_((int)((int)((92.0f + 163.0f * Math.min(1.0f, this.animationTime / 15.0f)) * saturation)), (int)0, (int)255);
        GenericConfigScreen.tile(new Rectangle(this.f_96543_, this.f_96544_), vOffset, saturation, green);
    }

    public abstract ConfigStyleList<?> getList();
}

