/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.flytre.flytre_lib.api.gui.text_field.DropdownMenu;
import net.flytre.flytre_lib.api.gui.text_field.DropdownUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class AsynchronousDropdownMenu
extends DropdownMenu {
    private static final Supplier<String> LOADING = () -> I18n.m_118938_((String)"TEMP - Loading...", (Object[])new Object[0]);
    private volatile boolean loaded = false;

    public AsynchronousDropdownMenu(int x, int y, int width, int height, Supplier<DropdownMenu> supplier) {
        super(x, y, width, height, Component.m_130674_((String)"TEMP - Loading..."), List.of());
        this.editable = false;
        new Thread(() -> this.asyncLoad(supplier)).start();
    }

    public static AsynchronousDropdownMenu createEntityDropdown() {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        return new AsynchronousDropdownMenu(0, 0, Math.min(250, width), 20, DropdownUtils::createEntityDropdown);
    }

    private void asyncLoad(Supplier<DropdownMenu> supplier) {
        DropdownMenu menu = supplier.get();
        this.renderer = menu.getRenderer();
        this.setMatcher(menu.getMatcher());
        this.textXOffset = menu.getTextXOffset();
        this.setOptionRenderer(menu.getOptionRenderer());
        this.setEntryHeight(menu.getEntryWidth());
        this.editable = true;
        this.loaded = true;
    }

    @Override
    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.loaded) {
            String storedText = this.text;
            this.text = LOADING.get();
            super.m_6303_(matrices, mouseX, mouseY, delta);
            this.text = storedText;
        } else {
            super.m_6303_(matrices, mouseX, mouseY, delta);
        }
    }
}

