/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.base;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.flytre.flytre_lib.mixin.base.KeyBindingAccessor;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class KeyBindUtilsImpl {
    private static final List<KeyMapping> BINDS = new ArrayList<KeyMapping>();

    private KeyBindUtilsImpl() {
    }

    private static Map<String, Integer> getCategoryMap() {
        return KeyBindingAccessor.getCategoryMap();
    }

    public static void addCategoryIfNecessary(String key) {
        Map<String, Integer> map = KeyBindUtilsImpl.getCategoryMap();
        if (!map.containsKey(key)) {
            int value = map.values().stream().max(Integer::compareTo).orElse(0) + 1;
            map.put(key, value);
        }
    }

    public static KeyMapping register(KeyMapping binding) {
        KeyBindUtilsImpl.addCategoryIfNecessary(binding.m_90858_());
        BINDS.add(binding);
        return binding;
    }

    public static KeyMapping[] process(KeyMapping[] current) {
        ArrayList modified = Lists.newArrayList((Object[])current);
        modified.removeAll(BINDS);
        modified.addAll(BINDS);
        return modified.toArray(new KeyMapping[0]);
    }
}

