/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.upgrade;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.flytre.flytre_lib.api.base.util.InventoryUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface UpgradeInventory {
    public static CompoundTag toTag(CompoundTag tag, NonNullList<ItemStack> stacks) {
        return InventoryUtils.writeNbt(tag, stacks, "Upgrades");
    }

    public static CompoundTag fromTag(CompoundTag tag, NonNullList<ItemStack> stacks) {
        return InventoryUtils.readNbt(tag, stacks, "Upgrades");
    }

    public NonNullList<ItemStack> getUpgrades();

    default public int upgradeSlots() {
        return this.getUpgrades().size();
    }

    default public boolean hasNoUpgrades() {
        for (int i = 0; i < this.upgradeSlots(); ++i) {
            ItemStack stack = this.getUpgrade(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getUpgrade(int slot) {
        return (ItemStack)this.getUpgrades().get(slot);
    }

    default public ItemStack removeUpgrade(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.getUpgrades(), (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.markUpgradesDirty();
        }
        return result;
    }

    default public ItemStack removeUpgrade(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.getUpgrades(), (int)slot);
        this.markUpgradesDirty();
        return stack;
    }

    default public void setUpgrade(int slot, ItemStack stack) {
        this.getUpgrades().set(slot, (Object)stack);
        if (stack.m_41613_() > this.getMaxUpgradeSlotCount()) {
            stack.m_41764_(this.getMaxUpgradeSlotCount());
        }
        this.markUpgradesDirty();
    }

    default public void clearUpgrades() {
        this.getUpgrades().clear();
    }

    default public int[] getAvailableUpgradeSlots() {
        return IntStream.range(0, this.upgradeSlots()).toArray();
    }

    default public int upgradeQuantity(Item item) {
        int i = 0;
        for (int j = 0; j < this.upgradeSlots(); ++j) {
            ItemStack itemStack = this.getUpgrade(j);
            if (!itemStack.m_41720_().equals(item)) continue;
            i += itemStack.m_41613_();
        }
        return i;
    }

    default public boolean hasUpgrade(Item upgrade) {
        return this.getUpgrades().stream().anyMatch(i -> i.m_41720_() == upgrade);
    }

    default public int getMaxUpgradeSlotCount() {
        return 64;
    }

    default public void markUpgradesDirty() {
    }

    default public Set<Item> validUpgrades() {
        return new HashSet<Item>();
    }

    default public boolean isValidUpgrade(ItemStack stack) {
        return this.validUpgrades().contains(stack.m_41720_());
    }
}

