/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class QuantifiedIngredient
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final int quantity;

    public QuantifiedIngredient(Ingredient ingredient, int quantity) {
        this.ingredient = ingredient;
        this.quantity = quantity;
    }

    public static QuantifiedIngredient fromJson(JsonElement json) {
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json);
        int quantity = 1;
        if (json.isJsonObject() && GsonHelper.m_13894_((JsonObject)((JsonObject)json), (String)"count")) {
            quantity = GsonHelper.m_13927_((JsonObject)((JsonObject)json), (String)"count");
        }
        return new QuantifiedIngredient(ingredient, quantity);
    }

    public static QuantifiedIngredient fromPacket(FriendlyByteBuf buf) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int quantity = buf.readInt();
        return new QuantifiedIngredient(ingredient, quantity);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void toPacket(FriendlyByteBuf packet) {
        this.ingredient.m_43923_(packet);
        packet.writeInt(this.quantity);
    }

    public boolean isEmpty() {
        return this.ingredient.m_43947_() || this.quantity == 0;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && stack.m_41613_() >= this.quantity;
    }

    public ItemStack[] getMatchingStacks() {
        ItemStack[] result;
        this.ingredient.m_43908_();
        for (ItemStack stack : result = this.ingredient.m_43908_()) {
            stack.m_41764_(this.quantity);
        }
        return result;
    }

    public String toString() {
        return "QuantifiedIngredient{ingredient=" + this.ingredient.m_43942_() + ", quantity=" + this.quantity + "}";
    }
}

