/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.flytre.flytre_lib.api.storage.recipe.TaggedItem;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public abstract class OutputProvider {
    protected final double chance;

    private OutputProvider(double chance) {
        this.chance = chance;
    }

    public static OutputProvider fromPacket(FriendlyByteBuf buf) {
        Types type = (Types)buf.m_130066_(Types.class);
        if (type == Types.ENCHANT) {
            return EnchantmentOutputProvider.fromPacket(buf);
        }
        if (type == Types.TAG) {
            return TagOutputProvider.fromPacket(buf);
        }
        if (type == Types.STACK) {
            return StackOutputProvider.fromPacket(buf);
        }
        throw new IllegalArgumentException("Invalid packet type");
    }

    public static OutputProvider fromJson(JsonElement jsonElement) {
        JsonObject json = null;
        if (jsonElement.isJsonObject()) {
            json = (JsonObject)jsonElement;
        }
        if (GsonHelper.m_13813_((JsonObject)json, (String)"tag")) {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            int i = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            double chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
            return new TagOutputProvider(new TaggedItem(id, i), chance);
        }
        if (jsonElement.isJsonPrimitive()) {
            String id = jsonElement.getAsString();
            ResourceLocation identifier2 = new ResourceLocation(id);
            ItemStack itemStack = Registry.f_122827_.m_6612_(identifier2).map(ItemStack::new).orElse(ItemStack.f_41583_);
            return new StackOutputProvider(itemStack, 1.0);
        }
        assert (json != null);
        String string = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        Item item = Registry.f_122827_.m_6612_(new ResourceLocation(string)).orElse(Items.f_41852_);
        int i = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        double chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
        if (GsonHelper.m_144762_((JsonObject)json, (String)"level")) {
            int level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
            boolean treasure = GsonHelper.m_13880_((JsonObject)json, (String)"treasure") && GsonHelper.m_13912_((JsonObject)json, (String)"treasure");
            return new EnchantmentOutputProvider(new ItemStack((ItemLike)item, i), chance, level, treasure);
        }
        return new StackOutputProvider(new ItemStack((ItemLike)item, i), chance);
    }

    public static OutputProvider from(ItemStack stack, double chance) {
        return new StackOutputProvider(stack, chance);
    }

    public static OutputProvider from(TaggedItem item, double chance) {
        return new TagOutputProvider(item, chance);
    }

    public static OutputProvider from(ItemStack stack, double chance, int level, boolean treasure) {
        return new EnchantmentOutputProvider(stack, chance, level, treasure);
    }

    abstract ItemStack getStack();

    public double getChance() {
        return this.chance;
    }

    public void toPacket(FriendlyByteBuf buf) {
        if (this instanceof EnchantmentOutputProvider) {
            buf.m_130068_((Enum)Types.ENCHANT);
        }
        if (this instanceof StackOutputProvider) {
            buf.m_130068_((Enum)Types.STACK);
        } else if (this instanceof TagOutputProvider) {
            buf.m_130068_((Enum)Types.TAG);
        } else {
            throw new IllegalStateException();
        }
        this.toPacketImpl(buf);
    }

    protected abstract void toPacketImpl(FriendlyByteBuf var1);

    private static enum Types {
        STACK,
        TAG,
        ENCHANT;

    }

    private static class EnchantmentOutputProvider
    extends StackOutputProvider {
        private static final Random RANDOM = new Random();
        private final int level;
        private final boolean treasure;

        public EnchantmentOutputProvider(ItemStack stack, double chance, int level, boolean treasure) {
            super(stack, chance);
            this.level = level;
            this.treasure = treasure;
        }

        public static OutputProvider fromPacket(FriendlyByteBuf buf) {
            ItemStack stack = buf.m_130267_();
            double chance = buf.readDouble();
            int level = buf.readInt();
            boolean treasure = buf.readBoolean();
            return new EnchantmentOutputProvider(stack, chance, level, treasure);
        }

        @Override
        public ItemStack getStack() {
            ItemStack stack = super.getStack();
            if (!stack.m_41793_()) {
                EnchantmentHelper.m_44877_((Random)RANDOM, (ItemStack)stack, (int)this.level, (boolean)this.treasure);
            }
            return stack;
        }

        @Override
        public void toPacketImpl(FriendlyByteBuf buf) {
            super.toPacketImpl(buf);
            buf.writeInt(this.level);
            buf.writeBoolean(this.treasure);
        }

        @Override
        public String toString() {
            return "EnchantmentOutputProvider{chance=" + this.chance + ", stack=" + this.stack + ", level=" + this.level + ", treasure=" + this.treasure + "}";
        }
    }

    private static class TagOutputProvider
    extends OutputProvider {
        private final TaggedItem taggedItem;

        public TagOutputProvider(TaggedItem item, double chance) {
            super(chance);
            this.taggedItem = item;
        }

        public static OutputProvider fromPacket(FriendlyByteBuf buf) {
            TaggedItem item = new TaggedItem(buf.m_130281_(), buf.readInt());
            return new TagOutputProvider(item, buf.readDouble());
        }

        @Override
        ItemStack getStack() {
            return this.taggedItem.getItemStack();
        }

        @Override
        public void toPacketImpl(FriendlyByteBuf buf) {
            buf.m_130085_(this.taggedItem.getPath());
            buf.writeInt(this.taggedItem.getQty());
            buf.writeDouble(this.chance);
        }

        public String toString() {
            return "TagOutputProvider{chance=" + this.chance + ", taggedItem=" + this.taggedItem + "}";
        }
    }

    private static class StackOutputProvider
    extends OutputProvider {
        protected final ItemStack stack;

        public StackOutputProvider(ItemStack stack, double chance) {
            super(chance);
            this.stack = stack;
        }

        public static OutputProvider fromPacket(FriendlyByteBuf buf) {
            return new StackOutputProvider(buf.m_130267_(), buf.readDouble());
        }

        @Override
        ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void toPacketImpl(FriendlyByteBuf buf) {
            buf.m_130055_(this.stack);
            buf.writeDouble(this.chance);
        }

        public String toString() {
            return "StackOutputProvider{chance=" + this.chance + ", stack=" + this.stack + "}";
        }
    }
}

