/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.recipe;

import com.google.gson.JsonObject;
import java.util.Set;

public class JsonFraction {
    private static final Set<String> NUMERATOR_ALIASES = Set.of("n", "num", "numerator");
    private static final Set<String> DENOMINATOR_ALIASES = Set.of("d", "den", "denominator");
    private final int numerator;
    private final int denominator;

    public JsonFraction(int n, int d) {
        int gcd = JsonFraction.gcd(n, d);
        if (d < 0) {
            n *= -1;
            d *= -1;
        }
        if (d == 0) {
            throw new AssertionError((Object)"Fraction denominator cannot be 0!");
        }
        this.numerator = n / gcd;
        this.denominator = d / gcd;
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int t = a;
            a = b;
            b = t % b;
        }
        return a;
    }

    public static JsonFraction fromJson(JsonObject object) {
        Integer n = null;
        for (String key : NUMERATOR_ALIASES) {
            if (!object.has(key)) continue;
            n = object.get(key).getAsInt();
        }
        if (n == null) {
            throw new IllegalArgumentException("No numerator found in: " + object);
        }
        int d = 1;
        for (String key : DENOMINATOR_ALIASES) {
            if (!object.has(key)) continue;
            d = object.get(key).getAsInt();
        }
        return new JsonFraction(n, d);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonFraction fraction = (JsonFraction)o;
        return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
    }

    public int hashCode() {
        int result = this.numerator;
        result = 31 * result + this.denominator;
        return result;
    }

    public String toString() {
        return this.numerator + " / " + this.denominator;
    }
}

