/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.inventory.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.base.util.Formatter;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class FilterInventory
implements Container {
    private final int height;
    public NonNullList<ItemStack> items;
    private boolean matchNbt;
    private boolean matchMod;
    private int filterType;

    public FilterInventory(NonNullList<ItemStack> items, int filterType, int height, boolean matchNbt, boolean matchMod) {
        this.items = items;
        this.filterType = filterType;
        this.height = height;
        this.matchNbt = matchNbt;
        this.matchMod = matchMod;
    }

    public static FilterInventory readNbt(CompoundTag tag, int defaultHeight) {
        int height = tag.m_128441_("height") ? tag.m_128451_("height") : defaultHeight;
        int filterType = tag.m_128451_("type");
        boolean matchNbt = tag.m_128471_("nbtMatch");
        boolean matchMod = tag.m_128471_("modMatch");
        NonNullList items = NonNullList.m_122780_((int)(height * 9), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
        return new FilterInventory((NonNullList<ItemStack>)items, filterType, height, matchNbt, matchMod);
    }

    public static void appendFilterToTooltip(FilterInventory inv, List<Component> tooltip) {
        int sz;
        Style itemStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true));
        Style modStyle = Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.valueOf(true));
        int len = 0;
        if (!inv.matchMod) {
            Set<Item> filter = inv.getFilterItems();
            sz = filter.size();
            for (Item i2 : filter) {
                tooltip.add((Component)new TranslatableComponent(i2.m_5524_()).m_6270_(itemStyle));
                if (++len <= 8) continue;
                break;
            }
        } else {
            Set mods = inv.items.stream().map(i -> Formatter.getModFromModId(Registry.f_122827_.m_7981_((Object)i.m_41720_()).m_135827_())).collect(Collectors.toSet());
            sz = mods.size();
            for (String mod : mods) {
                tooltip.add((Component)new TextComponent(mod).m_6270_(itemStyle));
                if (++len <= 8) continue;
                break;
            }
        }
        if (len >= 9) {
            tooltip.add((Component)new TextComponent("\u00a77\u00a7o").m_7220_((Component)new TranslatableComponent("flytre_lib.filter.tooltip", new Object[]{sz - 9}).m_6270_(itemStyle)));
        }
        Style red_text = Style.f_131099_.m_131140_(ChatFormatting.RED);
        Style green_text = Style.f_131099_.m_131140_(ChatFormatting.GREEN);
        MutableComponent whitelist = new TranslatableComponent("flytre_lib.filter.whitelist").m_6270_(green_text);
        MutableComponent blacklist = new TranslatableComponent("flytre_lib.filter.blacklist").m_6270_(red_text);
        MutableComponent matchMod = new TranslatableComponent("flytre_lib.filter.mod_match.true").m_6270_(green_text);
        MutableComponent ignoreMod = new TranslatableComponent("flytre_lib.filter.mod_match.false").m_6270_(red_text);
        MutableComponent matchNbt = new TranslatableComponent("flytre_lib.filter.nbt_match.true").m_6270_(green_text);
        MutableComponent ignoreNbt = new TranslatableComponent("flytre_lib.filter.nbt_match.false").m_6270_(red_text);
        tooltip.add((Component)new TextComponent("").m_7220_((Component)(inv.getFilterType() == 0 ? whitelist : blacklist)));
        tooltip.add((Component)new TextComponent("").m_7220_((Component)(inv.isMatchMod() ? matchMod : ignoreMod)));
        tooltip.add((Component)new TextComponent("").m_7220_((Component)(inv.isMatchNbt() ? matchNbt : ignoreNbt)));
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int getInventoryWidth() {
        return 9;
    }

    public int getInventoryHeight() {
        return this.height;
    }

    public int m_6643_() {
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public boolean put(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        if (!this.matchNbt && this.m_18949_(Collections.singleton(stack.m_41720_()))) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            this.items.set(i, (Object)copy);
            return true;
        }
        return false;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        stack.m_41764_(1);
        this.items.set(slot, (Object)stack);
    }

    public void m_6596_() {
        this.fixItems();
    }

    private void fixItems() {
        NonNullList fixed = NonNullList.m_122780_((int)this.items.size(), (Object)ItemStack.f_41583_);
        int index = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            fixed.set(index++, (Object)stack);
        }
        this.items = fixed;
    }

    public Set<Item> getFilterItems() {
        HashSet<Item> res = new HashSet<Item>();
        for (ItemStack item : this.items) {
            res.add(item.m_41720_());
        }
        res.remove(Items.f_41852_);
        return res;
    }

    public boolean passFilterTest(ItemStack stack) {
        boolean bl;
        Set<Item> filterItems = this.getFilterItems();
        if (this.matchMod) {
            String stackMod = Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135827_();
            if (this.matchNbt) {
                return this.filterType == 0 == this.items.stream().anyMatch(test -> stackMod.equals(Registry.f_122827_.m_7981_((Object)test.m_41720_()).m_135827_()) && ItemStack.m_41658_((ItemStack)test, (ItemStack)stack));
            }
            return this.filterType == 0 == filterItems.stream().anyMatch(test -> stackMod.equals(Registry.f_122827_.m_7981_(test).m_135827_()));
        }
        boolean bl2 = bl = this.filterType == 0 == filterItems.contains(stack.m_41720_());
        if (!this.matchNbt) {
            return bl;
        }
        if (!bl) {
            return false;
        }
        Set stacks = this.items.stream().filter(i -> !i.m_41619_()).collect(Collectors.toSet());
        for (ItemStack test2 : stacks) {
            if (test2.m_41720_() != stack.m_41720_() || !ItemStack.m_41658_((ItemStack)test2, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public boolean isMatchNbt() {
        return this.matchNbt;
    }

    public void setMatchNbt(boolean matchNbt) {
        this.matchNbt = matchNbt;
    }

    public boolean isMatchMod() {
        return this.matchMod;
    }

    public void setMatchMod(boolean matchMod) {
        this.matchMod = matchMod;
    }

    public void toggleNbtMatch() {
        this.matchNbt = !this.matchNbt;
    }

    public void toggleModMatch() {
        this.matchMod = !this.matchMod;
    }

    public void toggleFilterType() {
        this.filterType = this.filterType == 1 ? 0 : 1;
    }

    public CompoundTag writeNbt() {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("type", this.filterType);
        tag.m_128405_("height", this.height);
        tag.m_128379_("nbtMatch", this.matchNbt);
        tag.m_128379_("modMatch", this.matchMod);
        return tag;
    }

    public void m_5856_(Player player) {
        player.m_6330_(SoundEvents.f_12064_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_5785_(Player player) {
        player.m_6330_(SoundEvents.f_12642_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_6330_(SoundEvents.f_12064_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

