/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.text_field;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TranslucentTextField
extends AbstractWidget {
    public static final ItemStack DEFAULT_ICON = new ItemStack((ItemLike)Items.f_42680_);
    protected final Font textRenderer;
    protected String text;
    protected boolean editable;
    protected boolean selecting;
    protected Selection selection;
    protected int maxLength;
    protected boolean drawsBackground;
    @Nullable
    protected Function<String, String> suggestion;
    @Nullable
    protected Consumer<String> listener;
    protected Predicate<String> textPredicate;
    protected TextFieldRenderer renderer;
    protected int xScroll = 0;
    protected int textXOffset = 0;
    protected boolean rightAligned = false;

    public TranslucentTextField(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.text = "";
        this.maxLength = 80;
        this.drawsBackground = true;
        this.editable = true;
        this.textPredicate = Objects::nonNull;
        this.selection = new Selection(0, 0);
        this.renderer = (renderer, matrices, text, fullText, x1, y1, color, cursor) -> this.textRenderer.m_92744_(matrices, FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_), x1, y1, color);
    }

    public TextFieldRenderer getRenderer() {
        return this.renderer;
    }

    public void setRightAligned(boolean rightAligned) {
        this.rightAligned = rightAligned;
    }

    public void setListener(@Nullable Consumer<String> listener) {
        this.listener = listener;
    }

    public void setTextXOffset(int textXOffset) {
        this.textXOffset = textXOffset;
    }

    public int getTextXOffset() {
        return this.textXOffset;
    }

    private boolean showCursorTime() {
        return System.currentTimeMillis() % 1000L < 500L;
    }

    protected MutableComponent m_5646_() {
        return new TranslatableComponent("gui.narrate.editBox", new Object[]{this.text, this.m_6035_()});
    }

    public void m_142291_(NarrationElementOutput builder) {
        super.m_168802_(builder);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.textPredicate.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.setCursorToEnd();
            this.setSelectionEnd(this.selection.start);
            this.onChanged(text);
        }
    }

    public TranslucentTextField withText(String text) {
        this.setText(text);
        return this;
    }

    public String getSelectedText() {
        return this.text.substring(this.selection.ordered().start, this.selection.ordered().end);
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public void write(String text) {
        String modified;
        String string;
        int length;
        int charactersLeft = this.maxLength - this.text.length() + this.selection.ordered().length();
        if (charactersLeft < (length = (string = SharedConstants.m_136190_((String)text)).length())) {
            string = string.substring(0, charactersLeft);
            length = charactersLeft;
        }
        if (this.textPredicate.test(modified = new StringBuilder(this.text).replace(this.selection.ordered().start, this.selection.ordered().end, string).toString())) {
            this.text = modified;
            this.setSelectionStart(this.selection.ordered().start + length);
            this.setSelectionEnd(this.selection.start);
            this.onChanged(this.text);
        }
    }

    protected void onChanged(String newText) {
        if (this.listener != null) {
            this.listener.accept(newText);
        }
    }

    private void delete(int offset) {
        if (Screen.m_96637_()) {
            this.deleteWords(offset);
        } else {
            this.deleteCharacters(offset);
        }
    }

    private void deleteWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selection.end != this.selection.start) {
                this.write("");
            } else {
                this.deleteCharacters(this.getWordSkipPosition(wordOffset) - this.selection.start);
            }
        }
    }

    public void deleteCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selection.end != this.selection.start) {
                this.write("");
            } else {
                String modifier;
                int rightBound;
                int cursorPos = this.getCursorPosWithOffset(characterOffset);
                int leftBound = Math.min(cursorPos, this.selection.start);
                if (leftBound != (rightBound = Math.max(cursorPos, this.selection.start)) && this.textPredicate.test(modifier = new StringBuilder(this.text).delete(leftBound, rightBound).toString())) {
                    this.text = modifier;
                    this.setCursor(leftBound);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        EditBox widget = new EditBox(this.textRenderer, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, (Component)new TextComponent(""));
        widget.m_94144_(this.getText());
        widget.m_94196_(this.selection.start);
        return widget.m_94184_(wordOffset);
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return Util.m_137479_((String)this.text, (int)this.selection.start, (int)offset);
    }

    public void setSelectionStart(int cursor) {
        this.selection = this.selection.withStart(Mth.m_14045_((int)cursor, (int)0, (int)this.text.length()));
    }

    public void setSelectionEnd(int index) {
        int length = this.text.length();
        this.selection = this.selection.withEnd(Mth.m_14045_((int)index, (int)0, (int)length));
        if (this.textRenderer != null) {
            if (this.xScroll > length) {
                this.xScroll = length;
            }
            int width = this.getInnerWidth();
            String string = this.textRenderer.m_92834_(this.text.substring(this.xScroll), width - this.textXOffset);
            int length2 = string.length() + this.xScroll;
            if (this.selection.end == this.xScroll) {
                this.xScroll -= this.textRenderer.m_92837_(this.text, width - this.textXOffset, true).length();
            }
            if (this.selection.end > length2) {
                this.xScroll += this.selection.end - length2;
            } else if (this.selection.end <= this.xScroll) {
                this.xScroll -= this.xScroll - this.selection.end;
            }
            this.xScroll = Mth.m_14045_((int)this.xScroll, (int)0, (int)length);
        }
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        this.selecting = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.editable) {
                this.write(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.editable) {
                    this.selecting = false;
                    this.delete(-1);
                    this.selecting = Screen.m_96638_();
                }
                return true;
            }
            case 261: {
                if (this.editable) {
                    this.selecting = false;
                    this.delete(1);
                    this.selecting = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorToStart();
                return true;
            }
            case 269: {
                this.setCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            if (this.editable) {
                this.write(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        boolean inBounds = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        this.setTextFieldFocused(inBounds);
        if (this.m_93696_() && inBounds && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.f_93620_ - this.textXOffset;
            if (this.drawsBackground) {
                i -= 4;
            }
            String string = this.textRenderer.m_92834_(this.text.substring(this.xScroll), this.getInnerWidth());
            this.setCursor(this.textRenderer.m_92834_(string, i).length() + this.xScroll);
            return true;
        }
        return false;
    }

    public void setTextFieldFocused(boolean focused) {
        this.m_93692_(focused);
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            int y3;
            int x2;
            int y1;
            String suggested;
            int o;
            String string2;
            int topY;
            int color;
            if (this.drawsBackground) {
                color = this.m_93696_() ? -868862410 : 0x446B6B6B;
                RenderUtils.drawBorderedRect(new Rectangle(this.f_93620_ - 1, this.f_93621_ - 1, this.f_93618_ + 2, this.f_93619_ + 2), 0x446B6B6B, color, 1);
            }
            color = this.editable ? 0xE0E0E0 : 0x707070;
            int selectionStartLocation = this.selection.start - this.xScroll;
            int selectionEndLocation = this.selection.end - this.xScroll;
            String string = this.textRenderer.m_92834_(this.text.substring(this.xScroll), this.getInnerWidth() - 14);
            boolean selectionStartLocationInBounds = selectionStartLocation >= 0 && selectionStartLocation <= string.length();
            boolean cursorBlinkIn = this.m_93696_() && this.showCursorTime() && selectionStartLocationInBounds;
            int leftX = (this.drawsBackground ? this.f_93620_ + 4 : this.f_93620_) + this.textXOffset;
            int n = topY = this.drawsBackground ? this.f_93621_ + (this.f_93619_ - 8) / 2 : this.f_93621_;
            if (selectionEndLocation > string.length()) {
                selectionEndLocation = string.length();
            }
            String string3 = string2 = selectionStartLocationInBounds ? string.substring(0, selectionStartLocation) : string;
            if (!this.rightAligned) {
                o = this.renderer.render(this.textRenderer, matrices, string2, this.text, leftX, topY, color, false);
            } else {
                int rightX = this.getInnerWidth() + leftX;
                int width = this.textRenderer.m_92895_(string);
                o = this.renderer.render(this.textRenderer, matrices, string2, this.text, rightX - width, topY, color, false);
            }
            boolean bl3 = this.selection.start < this.text.length() || this.text.length() >= this.getMaxLength();
            int p = o;
            if (!selectionStartLocationInBounds) {
                p = selectionStartLocation > 0 ? leftX + this.f_93618_ : leftX;
            } else if (bl3) {
                p = o - 1;
                --o;
            }
            if (!string.isEmpty() && selectionStartLocationInBounds && selectionStartLocation < string.length()) {
                this.renderer.render(this.textRenderer, matrices, string.substring(selectionStartLocation), this.text, o, topY, color, true);
            }
            if (!bl3 && this.suggestion != null && (suggested = this.suggestion.apply(string)) != null) {
                this.textRenderer.m_92750_(matrices, suggested, (float)(p - 1), (float)topY, -8355712);
            }
            if (cursorBlinkIn) {
                if (bl3) {
                    y1 = topY - 1;
                    x2 = p + 1;
                    y3 = topY + 1;
                    Objects.requireNonNull(this.textRenderer);
                    GuiComponent.m_93172_((PoseStack)matrices, (int)p, (int)y1, (int)x2, (int)(y3 + 9), (int)-3092272);
                } else {
                    this.textRenderer.m_92750_(matrices, "_", (float)p, (float)topY, color);
                }
            }
            if (selectionEndLocation != selectionStartLocation) {
                int q = leftX + this.textRenderer.m_92895_(string.substring(0, selectionEndLocation));
                y1 = topY - 1;
                x2 = q - 1;
                y3 = topY + 1;
                Objects.requireNonNull(this.textRenderer);
                this.drawSelectionHighlight(Rectangle.fromBounds(p, y1, x2, y3 + 9));
            }
        }
    }

    private void drawSelectionHighlight(Rectangle rectangle) {
        if (rectangle.getRight() > this.f_93620_ + this.f_93618_) {
            rectangle = Rectangle.fromBounds(rectangle.getLeft(), rectangle.getTop(), this.f_93620_ + this.f_93618_, rectangle.getBottom());
        }
        if (rectangle.getLeft() > this.f_93620_ + this.f_93618_) {
            rectangle = Rectangle.fromBounds(this.f_93620_ + this.f_93618_, rectangle.getTop(), rectangle.getRight(), rectangle.getBottom());
        }
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        RenderUtils.drawRectangle(rectangle, -1728004097);
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.text = this.text.substring(0, maxLength);
            this.onChanged(this.text);
        }
    }

    public int getCursor() {
        return this.selection.start;
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selection.start);
        }
        this.onChanged(this.text);
    }

    public void setDrawsBackground(boolean drawsBackground) {
        this.drawsBackground = drawsBackground;
    }

    public boolean m_5755_(boolean lookForwards) {
        return this.f_93624_ && this.editable && super.m_5755_(lookForwards);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
    }

    private boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getInnerWidth() {
        return (this.drawsBackground ? this.f_93618_ - 8 : this.f_93618_) - 6;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.f_93620_ : this.f_93620_ + this.textRenderer.m_92895_(this.text.substring(0, index));
    }

    public void setX(int x) {
        this.f_93620_ = x;
    }

    public void setRenderer(TextFieldRenderer renderer) {
        this.renderer = renderer;
    }

    public void setSuggestion(@Nullable Function<String, String> suggestion) {
        this.suggestion = suggestion;
    }

    public int getFullHeight() {
        return this.f_93619_;
    }

    static {
        CompoundTag tag = DEFAULT_ICON.m_41784_();
        tag.m_128359_("SkullOwner", "MHF_Question");
    }

    private record Selection(int start, int end) {
        public int length() {
            return this.end - this.start;
        }

        public Selection withEnd(int newEnd) {
            return new Selection(this.start, newEnd);
        }

        public Selection withStart(int newStart) {
            return new Selection(newStart, this.end);
        }

        public Selection ordered() {
            if (this.start > this.end) {
                return new Selection(this.end, this.start);
            }
            return this;
        }
    }

    @FunctionalInterface
    public static interface TextFieldRenderer {
        public int render(Font var1, PoseStack var2, String var3, String var4, float var5, float var6, int var7, boolean var8);
    }
}

