/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.text_field;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class NumberBox
extends TranslucentTextField {
    private final boolean integers;

    public NumberBox(int x, int y, int width, int height, Component message, boolean integers, double startingValue) {
        this(x, y, width, height, message, integers, startingValue, null);
    }

    public NumberBox(int x, int y, int width, int height, Component message, boolean integers, double startingValue, @Nullable ValueRange range) {
        super(x, y, width - 20, height, message);
        this.rightAligned = true;
        this.textPredicate = text -> {
            try {
                double val = integers ? (double)Integer.parseInt(text) : Double.parseDouble(text);
                return range == null || val >= range.min() && val <= range.max();
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        this.text = integers ? String.valueOf((int)startingValue) : String.valueOf(startingValue);
        this.integers = integers;
    }

    public Rectangle topButton() {
        return new Rectangle(this.f_93620_ + this.f_93618_ + 2, this.f_93621_ - 1, 20, this.f_93619_ / 2);
    }

    public Rectangle botButton() {
        return new Rectangle(this.f_93620_ + this.f_93618_ + 2, this.f_93621_ + 1 + this.f_93619_ / 2, 20, this.f_93619_ / 2);
    }

    @Override
    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6303_(matrices, mouseX, mouseY, delta);
        if (this.isVisible() && this.drawsBackground) {
            Rectangle top = this.topButton();
            Rectangle bot = this.botButton();
            int color = this.m_93696_() ? -868862410 : -870704614;
            RenderUtils.drawBorderedRect(top, RenderUtils.getModernUiColor(true, top.contains(mouseX, mouseY)), color, 1);
            RenderUtils.drawBorderedRect(bot, RenderUtils.getModernUiColor(true, bot.contains(mouseX, mouseY)), color, 1);
            int n = this.f_93619_ / 2;
            Objects.requireNonNull(this.textRenderer);
            int offset = (n - 9) / 2 + 1;
            NumberBox.m_93208_((PoseStack)matrices, (Font)this.textRenderer, (String)"\u25b2", (int)top.getCenterX(), (int)(this.f_93621_ + offset), (int)-1429418804);
            NumberBox.m_93208_((PoseStack)matrices, (Font)this.textRenderer, (String)"\u25bc", (int)bot.getCenterX(), (int)(this.f_93621_ + 2 + this.f_93619_ / 2 + offset), (int)-1429418804);
        }
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || super.m_5953_(mouseX - 20.0, mouseY);
    }

    public void increment() {
        double curr = Double.parseDouble(this.text);
        double amt = Math.pow(10.0, String.valueOf(Math.abs((int)curr)).length() - 1);
        if (this.integers) {
            amt = Math.max(amt, 1.0);
        }
        if (!this.integers) {
            this.setText(String.valueOf(amt + curr));
        } else {
            this.setText(String.valueOf((int)(amt + curr)));
        }
    }

    public void decrement() {
        double curr = Double.parseDouble(this.text);
        double amt = Math.pow(10.0, String.valueOf(Math.abs((int)curr)).length() - 1);
        if (this.integers) {
            amt = Math.max(amt, 1.0);
        }
        if (!this.integers) {
            this.setText(String.valueOf(curr - amt));
        } else {
            this.setText(String.valueOf((int)(curr - amt)));
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isVisible() && this.editable) {
            if (this.topButton().contains(mouseX, mouseY)) {
                this.increment();
            } else if (this.botButton().contains(mouseX, mouseY)) {
                this.decrement();
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_5534_(char chr, int modifiers) {
        return (chr == '.' || '0' <= chr && chr <= '9') && super.m_5534_(chr, modifiers);
    }

    public void m_93674_(int value) {
        super.m_93674_(value - 20);
    }

    public record ValueRange(double min, double max) {
    }
}

