/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.text_field;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.flytre.flytre_lib.api.gui.text_field.DropdownUtils;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class DropdownMenu
extends TranslucentTextField {
    private final List<String> options;
    private List<String> matchedOptions;
    protected BiPredicate<String, String> matcher;
    private int entryHeight;
    private int entryWidth;
    private OptionRenderer optionRenderer;
    private int maxRenderedEntries;
    private int scroll;
    private boolean scrolling;

    public DropdownMenu(int x, int y, int width, int height, Component message, List<String> options) {
        super(x, y, width, height, message);
        this.options = options;
        this.matchedOptions = options;
        this.matcher = (option, text) -> option.contains((CharSequence)text) && !option.equals(text);
        this.entryHeight = this.f_93619_;
        this.entryWidth = this.f_93618_;
        this.optionRenderer = DropdownUtils::defaultRenderer;
        this.maxRenderedEntries = 10;
        this.scroll = 0;
        this.renderer = (renderer, matrices, text, fullText, x1, y1, color, cursor) -> {
            Style style = options.contains(fullText) ? Style.f_131099_ : Style.f_131099_.m_131140_(ChatFormatting.RED);
            return this.textRenderer.m_92744_(matrices, FormattedCharSequence.m_13714_((String)text, (Style)style), x1, y1, color);
        };
    }

    public void setMaxRenderedEntries(int maxRenderedEntries) {
        this.maxRenderedEntries = maxRenderedEntries;
    }

    private int maxScroll() {
        return Math.max(0, this.matchedOptions.size() - this.maxRenderedEntries);
    }

    private int dropdownYSize() {
        return Math.max(0, this.entryHeight * Math.min(this.maxRenderedEntries, this.matchedOptions.size()) - 2);
    }

    public BiPredicate<String, String> getMatcher() {
        return this.matcher;
    }

    private Rectangle scrollbarPos() {
        float percent1 = Mth.m_14036_((float)((float)this.maxRenderedEntries / (float)this.matchedOptions.size()), (float)0.0f, (float)1.0f);
        int size = (int)(percent1 * (float)this.dropdownYSize());
        float percent2 = Mth.m_14036_((float)((float)this.scroll / (float)this.matchedOptions.size()), (float)0.0f, (float)1.0f);
        int scrollY = (int)(percent2 * (float)this.dropdownYSize()) + 1;
        return new Rectangle(this.f_93620_ + this.entryWidth, this.f_93621_ + this.f_93619_ + 1 + scrollY, 5, size);
    }

    public void setOptionRenderer(OptionRenderer optionRenderer) {
        this.optionRenderer = optionRenderer;
    }

    public OptionRenderer getOptionRenderer() {
        return this.optionRenderer;
    }

    public void setEntryHeight(int entryHeight) {
        this.entryHeight = entryHeight;
    }

    public void setEntryWidth(int entryWidth) {
        this.entryWidth = entryWidth;
    }

    public int getEntryWidth() {
        return this.entryWidth;
    }

    public void setMatcher(BiPredicate<String, String> matcher) {
        this.matcher = matcher;
    }

    private void updatedMatchedOptions() {
        this.matchedOptions = this.options.stream().filter(i -> this.matcher.test((String)i, this.text)).collect(Collectors.toList());
    }

    @Override
    protected void onChanged(String newText) {
        super.onChanged(newText);
        this.updatedMatchedOptions();
    }

    @Override
    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6303_(matrices, mouseX, mouseY, delta);
        if (this.isActive() && this.drawsBackground) {
            int leftX = this.f_93620_ + 4 + this.textXOffset;
            int topY = this.f_93621_ + (this.f_93619_ - 8) / 2;
            if (!this.matchedOptions.isEmpty()) {
                int entries = Math.min(this.maxRenderedEntries, this.matchedOptions.size());
                Rectangle bounds = new Rectangle(this.f_93620_, this.f_93621_ + this.f_93619_ + 1, this.entryWidth + 6, this.entryHeight * entries);
                RenderUtils.drawBorderedRect(bounds, 0x446B6B6B, -868401859, 1);
                bounds = new Rectangle(this.f_93620_ + this.entryWidth - 1, this.f_93621_ + this.f_93619_ + 2, 1, this.entryHeight * entries - 2);
                RenderUtils.drawRectangle(bounds, -868401859);
                for (int i = 0; i < entries; ++i) {
                    String option = this.matchedOptions.get(i + this.setScroll(this.scroll));
                    String toRender = this.optionRenderer.toRender(option, this.text, this.textRenderer, this.renderer, this.entryWidth, this.entryHeight, this.textXOffset);
                    this.renderer.render(this.textRenderer, matrices, toRender, option, leftX, topY + this.f_93619_ + 1 + this.entryHeight * i, 0xE0E0E0, false);
                }
                int selectionIndex = this.getSelectionIndex(mouseX, mouseY);
                if (selectionIndex >= 0 && selectionIndex < this.matchedOptions.size()) {
                    Rectangle rectangle = new Rectangle(this.f_93620_, this.f_93621_ + this.f_93619_ + 1 + this.entryHeight * selectionIndex, this.entryWidth, this.entryHeight).reducedBy(1);
                    RenderUtils.drawRectangle(rectangle, 0x33000000);
                }
                bounds = this.scrollbarPos();
                RenderUtils.drawRectangle(bounds, -1442840576);
            }
            this.f_93622_ = this.m_5953_(mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int selectionIndex;
        this.checkScrollingOnClick(mouseX, mouseY, button);
        if (this.scrolling) {
            return true;
        }
        if (this.isActive() && this.editable && !this.matchedOptions.isEmpty() && (selectionIndex = this.getSelectionIndex((int)mouseX, (int)mouseY)) >= 0 && selectionIndex < Math.min(this.maxRenderedEntries, this.matchedOptions.size())) {
            String option = this.matchedOptions.get(selectionIndex + this.scroll);
            this.setText(option);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setScroll(this.scroll);
    }

    public int getSelectionIndex(int mouseX, int mouseY) {
        if (mouseX < this.f_93620_ || mouseX > this.entryWidth + this.f_93620_) {
            return -1;
        }
        int topY = this.f_93621_ + (this.f_93619_ - 8) / 2;
        int cy = topY + this.f_93619_ + 1;
        int index = 0;
        if (mouseY < cy) {
            return -1;
        }
        while (mouseY > cy + 20) {
            ++index;
            cy += this.entryHeight;
        }
        return index;
    }

    protected void checkScrollingOnClick(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && this.scrollbarPos().contains(mouseX, mouseY);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        if (super.m_5953_(mouseX, mouseY)) {
            return true;
        }
        Rectangle bounds = new Rectangle(this.f_93620_, this.f_93621_ + this.f_93619_ + 1, this.entryWidth + this.scrollbarPos().getWidth(), this.dropdownYSize());
        return this.m_93696_() && bounds.contains(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling && button == 0) {
            this.setScroll((int)((double)this.scroll + deltaY * 0.5));
            return true;
        }
        return false;
    }

    public int setScroll(int scroll) {
        this.scroll = Mth.m_14045_((int)scroll, (int)0, (int)this.maxScroll());
        return this.scroll;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.setScroll((int)((double)this.scroll - amount * (double)this.entryHeight / 4.0));
        return true;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.isActive()) {
            switch (keyCode) {
                case 258: {
                    if (0 < Math.min(this.maxRenderedEntries, this.matchedOptions.size())) {
                        String option = this.matchedOptions.get(this.scroll);
                        this.setText(option);
                        return true;
                    }
                }
                case 264: {
                    this.setScroll(this.scroll + 1);
                    return true;
                }
                case 265: {
                    this.setScroll(this.scroll - 1);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getFullHeight() {
        return (this.isActive() ? this.dropdownYSize() : 0) + this.f_93619_;
    }

    @FunctionalInterface
    public static interface OptionRenderer {
        public String toRender(String var1, String var2, Font var3, TranslucentTextField.TextFieldRenderer var4, int var5, int var6, int var7);
    }
}

