/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.text_field;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.flytre.flytre_lib.api.base.math.Rectangle;
import net.flytre.flytre_lib.api.base.util.Formatter;
import net.flytre.flytre_lib.api.base.util.RenderUtils;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;

public class ColorWidget
extends TranslucentTextField {
    private final int radius = 50;
    private final int sliderWidth = 75;
    private int color = 0;
    private float brightness = 1.0f;
    private float alpha = 1.0f;

    public ColorWidget(int x, int y, int width, int height, Component message) {
        super(x + 25, y, width - 25, height, message);
    }

    public int getCenterY() {
        return this.f_93621_ + this.f_93619_ + 50 + 5;
    }

    @Override
    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6303_(matrices, mouseX, mouseY, delta);
        int color = this.m_93696_() ? -868862410 : -870704614;
        RenderUtils.drawBorderedRect(new Rectangle(this.f_93620_ - 25, this.f_93621_ - 1, 22, this.f_93619_ + 2), this.color, color, 1);
        if (this.isActive()) {
            if (this.drawsBackground) {
                RenderUtils.drawBorderedRect(this.getFocusedBounds(), 0x446B6B6B, -868401859, 1);
            }
            RenderUtils.drawColorWheel(this.f_93620_ + 1 + 75, this.getCenterY(), 50.0, this.brightness, this.alpha);
            RenderUtils.drawRectangle(this.getWidthSliderBounds(), 0x446B6B6B);
            RenderUtils.drawRectangle(this.getWidthSliderValueBounds(), -2013265920);
            RenderUtils.drawRectangle(this.getAlphaSliderBounds(), 0x446B6B6B);
            RenderUtils.drawRectangle(this.getAlphaSliderValueBounds(), -2013265920);
        }
    }

    public Rectangle getFocusedBounds() {
        return new Rectangle(this.f_93620_ + 1, this.f_93621_ + this.f_93619_ + 1, 150, 145);
    }

    public Rectangle getAlphaSliderBounds() {
        int offset = 38;
        return new Rectangle(this.f_93620_ + 1 + offset, this.getCenterY() + 50 + 20, 75, 5);
    }

    public Rectangle getAlphaSliderValueBounds() {
        int offset = 38;
        int valueOffset = (int)(this.alpha * 68.0f);
        return new Rectangle(this.f_93620_ + 1 + offset + valueOffset, this.getCenterY() + 50 + 20 - 1, 7, 7);
    }

    public Rectangle getWidthSliderBounds() {
        int offset = 38;
        return new Rectangle(this.f_93620_ + 1 + offset, this.getCenterY() + 50 + 10, 75, 5);
    }

    public Rectangle getWidthSliderValueBounds() {
        int offset = 38;
        int valueOffset = (int)(this.brightness * 68.0f);
        return new Rectangle(this.f_93620_ + 1 + offset + valueOffset, this.getCenterY() + 50 + 10 - 1, 7, 7);
    }

    public void m_93674_(int value) {
        super.m_93674_(value);
    }

    public int getColor() {
        int ret = this.color;
        if (this.text.length() < 8 && (this.color >> 24 & 0xFF) == 0) {
            ret |= 0xFF000000;
        }
        return ret;
    }

    @Override
    protected void onChanged(String newText) {
        try {
            this.color = Formatter.fromHexString(newText);
        }
        catch (NumberFormatException e) {
            TextColor t = TextColor.m_131268_((String)newText);
            this.color = t != null ? 0xFF000000 | t.m_131265_() : 0x446B6B6B;
        }
        super.onChanged(newText);
    }

    private boolean updateBrightness(double mouseX, double mouseY, int button) {
        Rectangle slider = this.getWidthSliderBounds();
        Rectangle sliderModifier = slider.expandedBy(2).horizontallyExpandedBy(30);
        if (sliderModifier.contains(mouseX, mouseY)) {
            this.brightness = Mth.m_14036_((float)((float)((mouseX - (double)slider.getLeft()) / (double)slider.getWidth())), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    private boolean updateAlpha(double mouseX, double mouseY, int button) {
        Rectangle slider = this.getAlphaSliderBounds();
        Rectangle sliderModifier = slider.expandedBy(2).horizontallyExpandedBy(30);
        if (sliderModifier.contains(mouseX, mouseY)) {
            this.alpha = Mth.m_14036_((float)((float)((mouseX - (double)slider.getLeft()) / (double)slider.getWidth())), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public int m_5711_() {
        return super.m_5711_() + 25;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.updateBrightness(mouseX, mouseY, button)) {
            return true;
        }
        if (this.updateAlpha(mouseX, mouseY, button)) {
            return true;
        }
        int centerX = this.f_93620_ + 1 + 75;
        int centerY = this.getCenterY();
        double dist = Math.sqrt(Math.pow(mouseX - (double)centerX, 2.0) + Math.pow(mouseY - (double)centerY, 2.0));
        if (dist < 50.0) {
            double phi = Math.atan2(mouseY - (double)centerY, mouseX - (double)centerX);
            int color = Color.HSBtoRGB((float)(phi / (Math.PI * 2)), (float)dist / 50.0f, this.brightness);
            Object hex = String.format("#%02x%02x%02x%02x", (int)(this.alpha * 255.0f), color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
            if (((String)hex).startsWith("#ff") && ((String)hex).length() == 9) {
                hex = "#" + ((String)hex).substring(3);
            }
            this.setText((String)hex);
            return true;
        }
        if (this.getFocusedBounds().contains(mouseX, mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.updateBrightness(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        if (super.m_5953_(mouseX, mouseY)) {
            return true;
        }
        return this.m_93696_() && this.getFocusedBounds().contains(mouseX, mouseY);
    }

    @Override
    public int getFullHeight() {
        return this.f_93619_ + (this.isActive() ? this.getFocusedBounds().getHeight() : 0);
    }
}

