/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.flytre.flytre_lib.api.gui.button.ButtonTooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class MultistateButton
extends Button {
    private final int textureWidth;
    private final int textureHeight;
    private final ResourceLocation texture;
    private final String id;
    private final int states;
    private int state;
    private Component[] tooltips;
    private ButtonTooltipRenderer tooltipRenderer;
    private boolean renderTooltipWithButton;

    public MultistateButton(int x, int y, int width, int height, int state, int states, ResourceLocation texture, Button.OnPress onPress, char id) {
        this(x, y, width, height, state, states, texture, onPress, "" + id);
    }

    public MultistateButton(int x, int y, int width, int height, int state, int states, ResourceLocation texture, Button.OnPress onPress, String id) {
        super(x, y, width, height, TextComponent.f_131282_, onPress);
        this.textureHeight = height * states * 2;
        this.textureWidth = width;
        this.texture = texture;
        this.state = state;
        this.id = id;
        this.states = states;
        this.renderTooltipWithButton = true;
    }

    private boolean isHovering(int mouseX, int mouseY) {
        return mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
    }

    public void setRenderTooltipWithButton(boolean renderTooltipWithButton) {
        this.renderTooltipWithButton = renderTooltipWithButton;
    }

    public void setTooltips(Component ... frames) {
        this.tooltips = frames;
    }

    public ButtonTooltipRenderer getTooltipRenderer() {
        return this.tooltipRenderer;
    }

    public void setTooltipRenderer(ButtonTooltipRenderer tooltipRenderer) {
        this.tooltipRenderer = tooltipRenderer;
    }

    public void cycleState() {
        ++this.state;
        this.state %= this.states;
    }

    public void m_7428_(PoseStack matrices, int mouseX, int mouseY) {
        if (this.tooltips == null) {
            return;
        }
        this.getTooltipRenderer().draw(matrices, Collections.singletonList(this.tooltips[this.getState()]), mouseX, mouseY);
    }

    public int getState() {
        return this.state;
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        this.f_93622_ = this.isHovering(mouseX, mouseY);
        int y = this.f_93619_ * this.state * 2;
        if (this.f_93622_) {
            y += this.f_93619_;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        MultistateButton.m_93133_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)y, (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
        Font renderer = mc.f_91062_;
        FormattedCharSequence orderedText = Component.m_130674_((String)this.id).m_7532_();
        renderer.m_92877_(matrices, orderedText, (float)(this.f_93620_ + this.f_93618_ / 2 - renderer.m_92724_(orderedText) / 2) + 0.5f, (float)this.f_93621_ + 4.5f, 0);
        if (this.isHovering(mouseX, mouseY) && this.renderTooltipWithButton) {
            int zOffset = this.m_93252_();
            this.m_93250_(zOffset + 100);
            this.m_7428_(matrices, mouseX, mouseY);
            this.m_93250_(zOffset);
        }
    }
}

