/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config.reference;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Reference<T> {
    @NotNull
    protected final ResourceLocation identifier;
    @Nullable
    protected T value;

    protected Reference(@NotNull ResourceLocation identifier) {
        this.identifier = identifier;
        this.value = null;
    }

    protected Reference(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    protected Reference(@NotNull ResourceLocation id, @Nullable T value) {
        this.identifier = id;
        this.value = value;
    }

    protected Reference(@NotNull T value, Registry<T> registry) {
        this.identifier = Objects.requireNonNull(registry.m_7981_(value));
        this.value = value;
    }

    @NotNull
    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @Nullable
    protected T getValue(ResourceKey<? extends Registry<? extends T>> key, Level world) {
        return (T)(this.value != null ? this.value : world.m_5962_().m_175515_(key).m_6612_(this.identifier).orElse(null));
    }

    public boolean hasValue(Level world) {
        return this.getValue(world) != null;
    }

    @Nullable
    public abstract T getValue(Level var1);

    public boolean isIn(Collection<? extends Reference<T>> references) {
        return references.contains(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return this.identifier.equals((Object)reference.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "{identifier=" + this.identifier + ", value=" + this.value + "}";
    }
}

