/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.flytre.flytre_lib.api.base.util.Formatter;

public final class ConfigColor {
    public final int value;

    public ConfigColor(int value) {
        this.value = value;
    }

    public String toString() {
        return "ConfigColor{value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigColor that = (ConfigColor)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static class ColorSerializer
    implements JsonSerializer<ConfigColor>,
    JsonDeserializer<ConfigColor> {
        public ConfigColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ConfigColor(Formatter.fromHexString(json.getAsString()));
        }

        public JsonElement serialize(ConfigColor src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Formatter.intToHexString(src.value));
        }
    }
}

