/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.mixin.base.EntityTrackerAccessor;
import net.flytre.flytre_lib.mixin.base.ThreadedAnvilChunkStorageAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class PlayerSearchUtils {
    public static Collection<ServerPlayer> allPlayers(@NotNull MinecraftServer server) {
        if (server.m_6846_() != null) {
            return Collections.unmodifiableCollection(server.m_6846_().m_11314_());
        }
        return Collections.emptyList();
    }

    public static Collection<ServerPlayer> allInWorld(@NotNull ServerLevel world) {
        return Collections.unmodifiableCollection(world.m_6907_());
    }

    public static Collection<ServerPlayer> tracking(@NotNull ServerLevel world, @NotNull ChunkPos pos) {
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static Collection<ServerPlayer> tracking(@NotNull BlockEntity blockEntity) {
        if (!blockEntity.m_58898_() || blockEntity.m_58904_().m_5776_()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return PlayerSearchUtils.tracking((ServerLevel)blockEntity.m_58904_(), blockEntity.m_58899_());
    }

    public static Collection<ServerPlayer> tracking(@NotNull ServerLevel world, @NotNull BlockPos pos) {
        return PlayerSearchUtils.tracking(world, new ChunkPos(pos));
    }

    public static Collection<ServerPlayer> around(@NotNull ServerLevel world, @NotNull Vec3 pos, double radius) {
        double radiusSquared = radius * radius;
        return PlayerSearchUtils.allInWorld(world).stream().filter(p -> p.m_20238_(pos) <= radiusSquared).collect(Collectors.toList());
    }

    public static Collection<ServerPlayer> around(@NotNull ServerLevel world, @NotNull Vec3i pos, double radius) {
        double radiusSquared = radius * radius;
        return PlayerSearchUtils.allInWorld(world).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= radiusSquared).collect(Collectors.toList());
    }

    public static Collection<ServerPlayer> tracking(@NotNull Entity entity) {
        ChunkSource manager = entity.f_19853_.m_7726_();
        if (manager instanceof ServerChunkCache) {
            ChunkMap storage = ((ServerChunkCache)manager).f_8325_;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)((ThreadedAnvilChunkStorageAccessor)storage).getEntityTrackers().get(entity.m_142049_());
            if (tracker != null) {
                return tracker.getPlayersTracking().stream().map(ServerPlayerConnection::m_142253_).collect(Collectors.toUnmodifiableSet());
            }
            return Collections.emptySet();
        }
        throw new IllegalArgumentException("Only supported on server worlds!");
    }

    private PlayerSearchUtils() {
    }
}

