/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public final class InventoryUtils {
    private InventoryUtils() {
        throw new AssertionError();
    }

    public static boolean isInventoryFull(Container inv, Direction direction) {
        return InventoryUtils.getAvailableSlots(inv, direction).allMatch(i -> {
            ItemStack itemStack = inv.m_8020_(i);
            return itemStack.m_41613_() >= itemStack.m_41741_();
        });
    }

    public static IntStream getAvailableSlots(Container inventory, Direction side) {
        return inventory instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)inventory).m_7071_(side)) : IntStream.range(0, inventory.m_6643_());
    }

    public static boolean canMergeItems(ItemStack first, ItemStack second) {
        if (first.m_41720_() != second.m_41720_()) {
            return false;
        }
        if (first.m_41773_() != second.m_41773_()) {
            return false;
        }
        if (first.m_41613_() > first.m_41741_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)first, (ItemStack)second);
    }

    public static boolean canUnifyStacks(ItemStack first, ItemStack second) {
        return InventoryUtils.canMergeItems(first, second) && first.m_41613_() + second.m_41613_() <= first.m_41741_();
    }

    public static boolean canInsert(Container inventory, ItemStack stack, int slot, @Nullable Direction side) {
        if (!inventory.m_7013_(slot, stack)) {
            return false;
        }
        return !(inventory instanceof WorldlyContainer) || ((WorldlyContainer)inventory).m_7155_(slot, stack, side);
    }

    public static boolean canExtract(Container inv, ItemStack stack, int slot, Direction facing) {
        return !(inv instanceof WorldlyContainer) || ((WorldlyContainer)inv).m_7157_(slot, stack, facing);
    }

    public static boolean isInventoryEmpty(Container inv, Direction facing) {
        return InventoryUtils.getAvailableSlots(inv, facing).allMatch(i -> inv.m_8020_(i).m_41619_());
    }

    @Nullable
    public static Container getInventoryAt(Level world, BlockPos blockPos) {
        return InventoryUtils.getInventoryAt(world, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
    }

    @Nullable
    public static Container getInventoryAt(Level world, double x, double y, double z) {
        List list;
        BlockEntity blockEntity;
        WorldlyContainer inventory = null;
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockState blockState = world.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            inventory = ((WorldlyContainerHolder)block).m_5840_(blockState, (LevelAccessor)world, blockPos);
        } else if (block instanceof EntityBlock && (blockEntity = world.m_7702_(blockPos)) instanceof Container && (inventory = (Container)blockEntity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            inventory = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockState, (Level)world, (BlockPos)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.m_6249_(null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            inventory = (Container)list.get(world.f_46441_.nextInt(list.size()));
        }
        return inventory;
    }

    public static List<ItemStack> getCombinedInventory(Inventory inv) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>((Collection<ItemStack>)inv.f_35974_);
        result.addAll((Collection<ItemStack>)inv.f_35976_);
        result.addAll((Collection<ItemStack>)inv.f_35975_);
        return result;
    }

    public static Map<Item, Integer> countInventoryContents(Container inventory) {
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (result.containsKey(stack.m_41720_())) {
                result.put(stack.m_41720_(), stack.m_41613_() + (Integer)result.get(stack.m_41720_()));
                continue;
            }
            result.put(stack.m_41720_(), stack.m_41613_());
        }
        return result;
    }

    public static ItemStack putStackInInventory(ItemStack stack, Container inventory) {
        return InventoryUtils.putStackInInventory(stack, inventory, 0, inventory.m_6643_());
    }

    public static ItemStack putStackInInventory(ItemStack stack, Container inventory, int minSlot, int maxSlot) {
        for (int i = minSlot; i < maxSlot && !stack.m_41619_(); ++i) {
            stack = InventoryUtils.mergeStackIntoSlot(stack, inventory, i);
        }
        return stack;
    }

    public static ItemStack mergeStackIntoSlot(ItemStack stack, Container inventory, int slot) {
        ItemStack itemStack = inventory.m_8020_(slot);
        boolean bl = false;
        if (itemStack.m_41619_()) {
            inventory.m_6836_(slot, stack);
            stack = ItemStack.f_41583_;
            bl = true;
        } else if (InventoryUtils.canMergeItems(itemStack, stack)) {
            int i = stack.m_41741_() - itemStack.m_41613_();
            int j = Math.min(stack.m_41613_(), i);
            stack.m_41774_(j);
            itemStack.m_41769_(j);
            boolean bl2 = bl = j > 0;
        }
        if (bl) {
            inventory.m_6596_();
        }
        return stack;
    }

    @Nullable
    public static ItemStack getHoldingStack(LivingEntity entity, Predicate<ItemStack> condition) {
        ItemStack stack = entity.m_21206_();
        if (!condition.test(stack)) {
            stack = entity.m_21205_();
        }
        if (!condition.test(stack)) {
            return null;
        }
        return stack;
    }

    public static CompoundTag writeNbt(CompoundTag tag, NonNullList<ItemStack> stacks, String key) {
        CompoundTag temp = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)temp, stacks);
        tag.m_128365_(key, temp.m_128423_("Items"));
        return tag;
    }

    public static CompoundTag readNbt(CompoundTag tag, NonNullList<ItemStack> stacks, String key) {
        CompoundTag temp = new CompoundTag();
        if (tag.m_128423_(key) == null) {
            return tag;
        }
        temp.m_128365_("Items", tag.m_128423_(key));
        ContainerHelper.m_18980_((CompoundTag)temp, stacks);
        return tag;
    }

    public static int getFirstEmptySlot(NonNullList<ItemStack> stacks) {
        return InventoryUtils.getFirstEmptySlot(stacks, 0, stacks.size());
    }

    public static int getFirstEmptySlot(NonNullList<ItemStack> stacks, int min, int max) {
        int index = -1;
        for (int i = min; i < max; ++i) {
            if (!((ItemStack)stacks.get(i)).m_41619_()) continue;
            index = i;
            break;
        }
        return index;
    }
}

