/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.util;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.ContainerData;

public final class Formatter {
    private static final String[] PREFIX_VALUES = new String[]{"", "k", "M", "G", "T", "P"};
    private static final Map<String, String> MOD_NAME_CACHE = Maps.newHashMap();
    private static final String FORMAT_INT = "%d";
    private static final String FORMAT_FLOAT = "%.2f";

    private Formatter() {
        throw new AssertionError();
    }

    public static int mapToInt(Map<Direction, Boolean> map) {
        boolean[] array = new boolean[]{map.get(Direction.NORTH), map.get(Direction.WEST), map.get(Direction.EAST), map.get(Direction.UP), map.get(Direction.DOWN), map.get(Direction.SOUTH)};
        return Formatter.booleansToInt(array);
    }

    public static Map<Direction, Boolean> intToMap(int n) {
        boolean[] array = Formatter.intsToBoolean(n, 6);
        HashMap<Direction, Boolean> result = new HashMap<Direction, Boolean>();
        result.put(Direction.NORTH, array[0]);
        result.put(Direction.WEST, array[1]);
        result.put(Direction.EAST, array[2]);
        result.put(Direction.UP, array[3]);
        result.put(Direction.DOWN, array[4]);
        result.put(Direction.SOUTH, array[5]);
        return result;
    }

    public static int booleansToInt(boolean[] arr) {
        int n = 0;
        int i = -1;
        while (i < arr.length - 1) {
            n += arr[++i] ? 1 << i : 0;
        }
        return n;
    }

    public static boolean[] intsToBoolean(int n, int size) {
        boolean[] result = new boolean[size];
        int i = size - 1;
        int c = 1 << i;
        while (i >= 0) {
            result[i] = n >= c;
            n = n >= c ? n - c : n;
            c = 1 << --i;
        }
        return result;
    }

    public static int[] splitInt(int x) {
        int[] result = new int[]{x, x == 0 ? 0 : Math.max((int)Math.log10(x) - 3, 0)};
        while (result[0] >= 10000) {
            result[0] = result[0] / 10;
        }
        return result;
    }

    public static int unsplit(int[] split) {
        return (int)((double)split[0] * Math.pow(10.0, split[1]));
    }

    public static String formatNumber(double num, String suffix) {
        return Formatter.formatNumber(num, suffix, false);
    }

    public static String formatNumber(double num, String suffix, boolean space) {
        int suffixIndex = 0;
        while (num >= 1000.0) {
            ++suffixIndex;
            num /= 1000.0;
        }
        String prefix = PREFIX_VALUES[suffixIndex];
        if (num == 0.0) {
            prefix = PREFIX_VALUES[0];
        } else if (num < 1.0) {
            num *= 1000.0;
            prefix = "m";
        }
        int format = num >= 100.0 ? 1 : 2;
        return String.format("%." + format + "f", num) + (space ? " " : "") + prefix + suffix;
    }

    public static String formatNumber(double value) {
        if (value > 1000.0) {
            return Formatter.formatNumber(value, "", false);
        }
        if (value == (double)((int)value)) {
            return String.format(FORMAT_INT, (int)value);
        }
        return String.format(FORMAT_FLOAT, value);
    }

    public static String getModFromModId(String modId) {
        if (modId == null) {
            return "";
        }
        String any = MOD_NAME_CACHE.getOrDefault(modId, null);
        if (any != null) {
            return any;
        }
        String name = LoaderProperties.getModName(modId);
        MOD_NAME_CACHE.put(modId, name);
        return name;
    }

    public static Component getModNameToolTip(String modId) {
        MutableComponent name = new TextComponent(Formatter.getModFromModId(modId)).m_7220_((Component)new TextComponent(""));
        name.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.valueOf(true)));
        return name;
    }

    public static BlockPos arrToPos(int[] arr) {
        return new BlockPos(arr[0], arr[1], arr[2]);
    }

    public static IntArrayTag writePosToNbt(BlockPos pos) {
        return new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public static int energy(ContainerData propertyDelegate) {
        return Formatter.unsplit(new int[]{propertyDelegate.m_6413_(3), propertyDelegate.m_6413_(4)});
    }

    public static int maxEnergy(ContainerData propertyDelegate) {
        return Math.max(Formatter.unsplit(new int[]{propertyDelegate.m_6413_(5), propertyDelegate.m_6413_(6)}), 1);
    }

    public static double sigmasEU(double joules) {
        return joules / 10.0;
    }

    public static double EUsigmas(double EU) {
        return EU * 10.0;
    }

    public static String intToHexString(int value) {
        Object hex = String.format("#%02x%02x%02x%02x", value >> 24 & 0xFF, value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF);
        if (((String)hex).startsWith("#00") && ((String)hex).length() == 9) {
            hex = "#" + ((String)hex).substring(3);
        }
        return hex;
    }

    public static int fromHexString(String hex) {
        int color;
        if (hex.startsWith("#") && hex.length() == 9) {
            Color awt = Color.decode("#" + hex.substring(3));
            int alpha = Integer.decode(hex.substring(0, 3));
            color = awt.getRGB() + (alpha << 24);
        } else {
            color = Color.decode(hex).getRGB();
        }
        return color;
    }
}

