/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.base.game;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import org.apache.commons.lang3.math.NumberUtils;

public class SidebarDisplayer {
    private final ServerScoreboard scoreboard;
    private final Objective objective;
    private final List<Entry> entries;
    private transient int entrySize;

    public SidebarDisplayer(ServerScoreboard scoreboard, Objective objective, List<Entry> entries) {
        this.entries = entries;
        this.entrySize = this.calculateEntrySize();
        this.objective = objective;
        this.scoreboard = scoreboard;
    }

    public SidebarDisplayer(ServerScoreboard scoreboard, Objective objective) {
        List<Score> scores = scoreboard.m_83498_(objective).stream().filter(i -> i.m_83400_() >= 0 && i.m_83400_() <= 15).sorted(Comparator.comparing(Score::m_83400_)).toList();
        this.scoreboard = scoreboard;
        this.objective = objective;
        this.entries = new ArrayList<Entry>();
        this.entrySize = 0;
        for (int i2 = 0; i2 < scores.size(); ++i2) {
            Score score = scores.get(i2);
            String text = score.m_83405_();
            if (text.replace("\u00a7r", "").length() == 0) {
                this.addEntry(new BlankEntry());
                continue;
            }
            if (i2 + 1 < scores.size() && NumberUtils.isCreatable((String)scores.get(i2 + 1).m_83405_())) {
                double next = Double.parseDouble(scores.get(i2++ + 1).m_83405_());
                this.addEntry(new ValueEntry(text, next));
                continue;
            }
            this.addEntry(new TextEntry(text));
        }
    }

    public ServerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    private int calculateEntrySize() {
        return this.entries.stream().map(Entry::getHeight).reduce(0, Integer::sum);
    }

    public void addEntry(Entry entry) {
        if (this.entrySize + entry.getHeight() > 16) {
            return;
        }
        this.entries.add(entry);
        this.entrySize += entry.getHeight();
    }

    public void clearEntries() {
        this.entries.clear();
        this.entrySize = 0;
    }

    public void update() {
        HashMap<String, Integer> usedScores = new HashMap<String, Integer>();
        HashSet<CallSite> usedScores2 = new HashSet<CallSite>();
        int score = 15;
        for (Entry entry : this.entries) {
            for (String string : entry.getText()) {
                usedScores.put(string, usedScores.getOrDefault(string, 0) + 1);
                String string2 = string + " ".repeat((Integer)usedScores.get(string) - 1);
                usedScores2.add((CallSite)((Object)string2));
                this.scoreboard.m_83471_(string2, this.objective).m_83402_(score--);
            }
        }
        this.scoreboard.m_83498_(this.objective).forEach(i -> {
            if (!usedScores2.contains(i.m_83405_())) {
                this.scoreboard.m_83479_(i.m_83405_(), this.objective);
            }
        });
    }

    public ImmutableList<Entry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public static final class BlankEntry
    extends Entry {
        public BlankEntry() {
            super(List.of(""), 1);
        }
    }

    public static class Entry {
        protected final int height;
        protected List<String> text;

        public Entry(List<String> text, int height) {
            this.text = text;
            this.height = height;
        }

        public List<String> getText() {
            return this.text;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return "Entry{height=" + this.height + ", text=" + this.text + "}";
        }
    }

    public static final class ValueEntry
    extends Entry {
        private double value;

        public ValueEntry(String text, double value) {
            super(List.of(text, ValueEntry.valueFor(value)), 2);
            this.value = value;
        }

        public static String valueFor(double x) {
            if (x == Math.rint(x)) {
                return "" + (int)x;
            }
            return "" + x;
        }

        public void setValue(double value) {
            if (this.value != value) {
                this.text = List.of((String)this.text.get(0), ValueEntry.valueFor(value));
                this.value = value;
            }
        }
    }

    public static final class TextEntry
    extends Entry {
        public TextEntry(String text) {
            super(Collections.singletonList(text), 1);
        }
    }
}

