/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.tooltips;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModList;
import net.obscuria.tooltips.ModConfig;

public class TooltipSystem {
    private static final Multimap<ResourceLocation, BiConsumer<ItemStack, List<TextComponent>>> TOOLTIPS = LinkedListMultimap.create();

    public static void add(boolean d, String i, String t) {
        if (d) {
            TooltipSystem.dark(i, t);
        } else {
            TooltipSystem.common(i, t);
        }
    }

    public static void add(boolean d, String i, String t1, String t2) {
        if (d) {
            TooltipSystem.dark(i, t2);
            TooltipSystem.dark(i, t1);
        } else {
            TooltipSystem.common(i, t2);
            TooltipSystem.common(i, t1);
        }
    }

    public static void add(boolean d, String i, String t1, String t2, String t3) {
        if (d) {
            TooltipSystem.dark(i, t3);
            TooltipSystem.dark(i, t2);
            TooltipSystem.dark(i, t1);
        } else {
            TooltipSystem.common(i, t3);
            TooltipSystem.common(i, t2);
            TooltipSystem.common(i, t1);
        }
    }

    public static void add(boolean d, String i, String t1, String t2, String t3, String t4) {
        if (d) {
            TooltipSystem.dark(i, t4);
            TooltipSystem.dark(i, t3);
            TooltipSystem.dark(i, t2);
            TooltipSystem.dark(i, t1);
        } else {
            TooltipSystem.common(i, t4);
            TooltipSystem.common(i, t3);
            TooltipSystem.common(i, t2);
            TooltipSystem.common(i, t1);
        }
    }

    public static void add(boolean d, String i, String t1, String t2, String t3, String t4, String t5) {
        if (d) {
            TooltipSystem.dark(i, t5);
            TooltipSystem.dark(i, t4);
            TooltipSystem.dark(i, t3);
            TooltipSystem.dark(i, t2);
            TooltipSystem.dark(i, t1);
        } else {
            TooltipSystem.common(i, t5);
            TooltipSystem.common(i, t4);
            TooltipSystem.common(i, t3);
            TooltipSystem.common(i, t2);
            TooltipSystem.common(i, t1);
        }
    }

    public static void setup() {
        if (((Boolean)ModConfig.Holder.essentialsTips.get()).booleanValue()) {
            TooltipSystem.dark("ob_core:afterlife_key", "afterlife_key_line3");
            TooltipSystem.dark("ob_core:afterlife_key", "afterlife_key_line2");
            TooltipSystem.dark("ob_core:afterlife_key", "afterlife_key_line1");
            TooltipSystem.dark("ob_core:splitting_table", "splitting_table_line3");
            TooltipSystem.dark("ob_core:splitting_table", "splitting_table_line2");
            TooltipSystem.dark("ob_core:splitting_table", "splitting_table_line1");
            TooltipSystem.dark("ob_core:platinum_ore", "platinum_ore_line2");
            TooltipSystem.dark("ob_core:platinum_ore", "platinum_ore_line1");
        }
        if (((Boolean)ModConfig.Holder.essentialsTooltips.get()).booleanValue()) {
            TooltipSystem.common("ob_core:magic_dust", "magic_dust_line2");
            TooltipSystem.common("ob_core:magic_dust", "magic_dust_line1");
            TooltipSystem.common("ob_core:scroll_primitive_rites", "scroll_primitive_rites_line2");
            TooltipSystem.common("ob_core:scroll_primitive_rites", "scroll_primitive_rites_line1");
            TooltipSystem.common("ob_core:runic_manual", "open");
            TooltipSystem.common("ob_core:shining_apple", "shining_apple_line2");
            TooltipSystem.common("ob_core:shining_apple", "shining_apple_line1");
            TooltipSystem.common("ob_core:shining_bone", "shining_bone_line2");
            TooltipSystem.common("ob_core:shining_bone", "shining_bone_line1");
            TooltipSystem.common("ob_core:rune_of_the_storm_empty", "rune_depleted");
            TooltipSystem.common("ob_core:obsidian_skin_potion", "obsidian_skin_potion_line2");
            TooltipSystem.common("ob_core:obsidian_skin_potion", "obsidian_skin_potion_line1");
        }
        if (((Boolean)ModConfig.Holder.aquamiraeTips.get()).booleanValue()) {
            TooltipSystem.dark("ob_aquamirae:shell_horn", "shell_horn_line2");
            TooltipSystem.dark("ob_aquamirae:shell_horn", "shell_horn_line1");
            TooltipSystem.dark("ob_aquamirae:frozen_key", "frozen_key_line2");
            TooltipSystem.dark("ob_aquamirae:frozen_key", "frozen_key_line1");
            TooltipSystem.dark("ob_aquamirae:frozen_chest", "frozen_chest_line2");
            TooltipSystem.dark("ob_aquamirae:frozen_chest", "frozen_chest_line1");
            TooltipSystem.dark("ob_aquamirae:rune_of_the_storm", "runes_line3");
            TooltipSystem.dark("ob_aquamirae:rune_of_the_storm", "runes_line2");
            TooltipSystem.dark("ob_aquamirae:rune_of_the_storm", "runes_line1");
        }
        if (((Boolean)ModConfig.Holder.aquamiraeTooltips.get()).booleanValue()) {
            TooltipSystem.common("ob_aquamirae:luminescent_bubble_item", "luminescent_light");
            TooltipSystem.common("ob_aquamirae:luminescent_lamp", "luminescent_light");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line6");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line5");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line4");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line3");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line2");
            TooltipSystem.common("ob_aquamirae:poseidons_breakfast", "poseidons_breakfast_line1");
            TooltipSystem.common("ob_aquamirae:oxygelium", "oxygelium");
            TooltipSystem.common("ob_aquamirae:esca", "esca");
            TooltipSystem.common("ob_aquamirae:sea_stew", "sea_stew_line4");
            TooltipSystem.common("ob_aquamirae:sea_stew", "sea_stew_line3");
            TooltipSystem.common("ob_aquamirae:sea_stew", "sea_stew_line2");
            TooltipSystem.common("ob_aquamirae:sea_stew", "sea_stew_line1");
            TooltipSystem.common("ob_aquamirae:sea_casserole", "sea_casserole_line2");
            TooltipSystem.common("ob_aquamirae:sea_casserole", "sea_casserole_line1");
            TooltipSystem.common("ob_aquamirae:spinefish", "spinefish");
            TooltipSystem.common("ob_aquamirae:cooked_spinefish", "cooked_spinefish");
            TooltipSystem.common("ob_aquamirae:rune_of_the_storm", "rune_of_the_storm_line2");
            TooltipSystem.common("ob_aquamirae:rune_of_the_storm", "rune_of_the_storm_line1");
            TooltipSystem.common("ob_aquamirae:shell_horn", "shell_horn");
            TooltipSystem.common("ob_aquamirae:dead_sea_scroll", "dead_sea_scroll_line2");
            TooltipSystem.common("ob_aquamirae:dead_sea_scroll", "dead_sea_scroll_line1");
            TooltipSystem.common("ob_aquamirae:ship_graveyard_echo", "ship_graveyard_echo_line3");
            TooltipSystem.common("ob_aquamirae:ship_graveyard_echo", "ship_graveyard_echo_line2");
            TooltipSystem.common("ob_aquamirae:ship_graveyard_echo", "ship_graveyard_echo_line1");
            TooltipSystem.common("ob_aquamirae:abyssal_amethyst", "abyssal_amethyst_line2");
            TooltipSystem.common("ob_aquamirae:abyssal_amethyst", "abyssal_amethyst_line1");
            TooltipSystem.common("ob_aquamirae:pirate_pouch", "pirate_pouch_line2");
            TooltipSystem.common("ob_aquamirae:pirate_pouch", "pirate_pouch_line1");
            TooltipSystem.common("ob_aquamirae:pirate_pouch", "open");
            TooltipSystem.common("ob_aquamirae:treasure_pouch", "treasure_pouch_line2");
            TooltipSystem.common("ob_aquamirae:treasure_pouch", "treasure_pouch_line1");
            TooltipSystem.common("ob_aquamirae:treasure_pouch", "open");
            TooltipSystem.common("ob_aquamirae:frozen_key", "frozen_key_line2");
            TooltipSystem.common("ob_aquamirae:frozen_key", "frozen_key_line1");
            TooltipSystem.common("ob_aquamirae:wisteria_niveis", "wisteria_niveis_line3");
            TooltipSystem.common("ob_aquamirae:wisteria_niveis", "wisteria_niveis_line2");
            TooltipSystem.common("ob_aquamirae:wisteria_niveis", "wisteria_niveis_line1");
            TooltipSystem.common("ob_aquamirae:wisteria_bottom", "wisteria_niveis_line3");
            TooltipSystem.common("ob_aquamirae:wisteria_bottom", "wisteria_niveis_line2");
            TooltipSystem.common("ob_aquamirae:wisteria_bottom", "wisteria_niveis_line1");
            TooltipSystem.common("ob_aquamirae:poisoned_chakram", "chakram_line2");
            TooltipSystem.common("ob_aquamirae:poisoned_chakram", "chakram_line1");
            TooltipSystem.common("ob_aquamirae:maze_rose", "chakram_line2");
            TooltipSystem.common("ob_aquamirae:maze_rose", "chakram_line1");
        }
        MinecraftForge.EVENT_BUS.addListener(TooltipSystem::insertTooltips);
    }

    private static void insertTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Collection tooltipEntries = TOOLTIPS.get((Object)stack.m_41720_().getRegistryName());
        if (tooltipEntries != null && !tooltipEntries.isEmpty()) {
            List itemTooltips = event.getToolTip();
            for (BiConsumer tooltipConsumer : tooltipEntries) {
                tooltipConsumer.accept(stack, itemTooltips);
            }
        }
    }

    private static void common(String id, String tooltip) {
        TooltipSystem.createTooltip(id, (stack, tooltips) -> tooltips.add(1, new TextComponent(new TranslatableComponent("tooltip." + tooltip).getString())));
    }

    private static void dark(String id, String tooltip) {
        TooltipSystem.createTooltip(id, (stack, tooltips) -> tooltips.add(1, new TextComponent(new TranslatableComponent("icon.stick_dark").getString() + new TranslatableComponent("tip." + tooltip).getString())));
    }

    private static void createTooltip(String id, BiConsumer<ItemStack, List<TextComponent>> tooltip) {
        ResourceLocation itemId = new ResourceLocation(id);
        if (ModList.get().isLoaded(itemId.m_135827_())) {
            TOOLTIPS.put((Object)new ResourceLocation(id), tooltip);
        }
    }
}

