/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.tooltips;

import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.obscuria.tooltips.ModConfig;

public class StatSystem {
    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(StatSystem::insertTooltips);
    }

    private static void insertTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (((Boolean)ModConfig.Holder.customStat.get()).booleanValue() && stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/custom")))) {
            Object tooltip = "";
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/damage")))) {
                tooltip = (String)tooltip + StatSystem.addDamage(stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/speed")))) {
                tooltip = (String)tooltip + StatSystem.addSpeed(stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/armor")))) {
                tooltip = (String)tooltip + StatSystem.addArmor(stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/energy")))) {
                tooltip = (String)tooltip + StatSystem.addEnergy(stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/souls")))) {
                tooltip = (String)tooltip + StatSystem.addSouls(stack);
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/durability")))) {
                tooltip = (String)tooltip + StatSystem.addDurability(stack);
            }
            event.getToolTip().add(1, new TextComponent((String)tooltip));
        } else {
            String tooltip;
            if (((Boolean)ModConfig.Holder.swordStat.get()).booleanValue() && stack.m_41720_() instanceof SwordItem) {
                tooltip = StatSystem.addDamage(stack) + StatSystem.addSpeed(stack) + StatSystem.addDurability(stack);
                event.getToolTip().add(1, new TextComponent(tooltip));
            }
            if (((Boolean)ModConfig.Holder.toolStat.get()).booleanValue() && (stack.m_41720_() instanceof PickaxeItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof ShovelItem || stack.m_41720_() instanceof HoeItem)) {
                tooltip = StatSystem.addDamage(stack) + StatSystem.addSpeed(stack) + StatSystem.addDurability(stack);
                event.getToolTip().add(1, new TextComponent(tooltip));
            }
            if (((Boolean)ModConfig.Holder.armorStat.get()).booleanValue() && stack.m_41720_() instanceof ArmorItem) {
                tooltip = StatSystem.addArmor(stack) + StatSystem.addDurability(stack);
                event.getToolTip().add(1, new TextComponent(tooltip));
            }
        }
        if (((Boolean)ModConfig.Holder.vanillaMaterials.get()).booleanValue() && stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/vanilla_materials")))) {
            event.getToolTip().add(new TranslatableComponent("tooltip.material"));
        }
        if (((Boolean)ModConfig.Holder.collectionMaterials.get()).booleanValue() && stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tooltips/collection_materials")))) {
            event.getToolTip().add(new TranslatableComponent("tooltip.material"));
        }
    }

    public static String addDamage(ItemStack stack) {
        Object damage = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).toString().replaceFirst(".*?amount=([0-9]+\\.[0-9]+).*", "$1");
        damage = "" + (new Object(){

            double convert(String s) {
                try {
                    return Double.parseDouble(s.trim());
                }
                catch (Exception exception) {
                    return 0.0;
                }
            }
        }.convert((String)damage) + 1.0);
        String result = new TranslatableComponent("stat.damage").getString() + (String)damage + " ";
        return result;
    }

    public static String addSpeed(ItemStack stack) {
        String speed = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).toString();
        String speedType = "none";
        double speedVal = 0.0;
        if (speed.length() > 30) {
            speedVal = new Object(){

                double convert(String s) {
                    try {
                        return Double.parseDouble(s.trim());
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            }.convert(speed = speed.substring(26, 30));
            speedType = speedVal < -2.9 ? "slow" : (speedVal < -1.9 ? "medium" : "fast");
        }
        String result = new TranslatableComponent("stat.attack_speed." + speedType).getString() + " ";
        return result;
    }

    public static String addArmor(ItemStack stack) {
        String armorHead = stack.m_41638_(EquipmentSlot.HEAD).get((Object)Attributes.f_22284_).toString();
        String armorChest = stack.m_41638_(EquipmentSlot.CHEST).get((Object)Attributes.f_22284_).toString();
        String armorLegs = stack.m_41638_(EquipmentSlot.LEGS).get((Object)Attributes.f_22284_).toString();
        String armorFeet = stack.m_41638_(EquipmentSlot.FEET).get((Object)Attributes.f_22284_).toString();
        double armorValue = 0.0;
        if (armorHead.length() > 30) {
            armorValue += new Object(){

                double convert(String s) {
                    try {
                        return Double.parseDouble(s.trim());
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            }.convert(armorHead.substring(26, 29));
        }
        if (armorChest.length() > 30) {
            armorValue += new Object(){

                double convert(String s) {
                    try {
                        return Double.parseDouble(s.trim());
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            }.convert(armorChest.substring(26, 29));
        }
        if (armorLegs.length() > 30) {
            armorValue += new Object(){

                double convert(String s) {
                    try {
                        return Double.parseDouble(s.trim());
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            }.convert(armorLegs.substring(26, 29));
        }
        if (armorFeet.length() > 30) {
            armorValue += new Object(){

                double convert(String s) {
                    try {
                        return Double.parseDouble(s.trim());
                    }
                    catch (Exception exception) {
                        return 0.0;
                    }
                }
            }.convert(armorFeet.substring(26, 29));
        }
        String result = "" + armorValue;
        return new TranslatableComponent("stat.armor").getString() + result.replace(".0", "") + " ";
    }

    public static String addEnergy(ItemStack stack) {
        String result = new TranslatableComponent("stat.energy").getString() + (stack.m_41776_() - stack.m_41773_()) + new TranslatableComponent("stat.separator").getString() + stack.m_41776_() + " ";
        return result;
    }

    public static String addSouls(ItemStack stack) {
        String result = new TranslatableComponent("stat.souls").getString() + (stack.m_41776_() - stack.m_41773_()) + new TranslatableComponent("stat.separator").getString() + stack.m_41776_() + " ";
        return result;
    }

    public static String addDurability(ItemStack stack) {
        String durability = "1";
        if ((double)stack.m_41773_() > (double)stack.m_41776_() * 0.8) {
            durability = "3";
        } else if ((double)stack.m_41773_() > (double)stack.m_41776_() * 0.5) {
            durability = "2";
        }
        String result = new TranslatableComponent("stat.durability." + durability).getString() + (stack.m_41776_() - stack.m_41773_()) + new TranslatableComponent("stat.separator").getString() + stack.m_41776_();
        return result;
    }
}

