/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.tooltips;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.obscuria.tooltips.ObTooltipsMod;

public class ModConfig {
    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path bopConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "Obscuria Collection");
        try {
            Files.createDirectory(bopConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ObTooltipsMod.LOGGER.warn("Failed to create Obscuria Collection config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Holder.SPEC, "Obscuria Collection/ob-tooltips.toml");
    }

    public static class Holder {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.BooleanValue vanillaMaterials;
        public static final ForgeConfigSpec.BooleanValue swordStat;
        public static final ForgeConfigSpec.BooleanValue toolStat;
        public static final ForgeConfigSpec.BooleanValue armorStat;
        public static final ForgeConfigSpec.BooleanValue customStat;
        public static final ForgeConfigSpec.BooleanValue collectionMaterials;
        public static final ForgeConfigSpec.BooleanValue essentialsTips;
        public static final ForgeConfigSpec.BooleanValue essentialsTooltips;
        public static final ForgeConfigSpec.BooleanValue aquamiraeTips;
        public static final ForgeConfigSpec.BooleanValue aquamiraeTooltips;

        static {
            BUILDER.push("Common");
            vanillaMaterials = BUILDER.comment("Display 'material' for crafting-only items").worldRestart().define("vanillaMaterials", true);
            swordStat = BUILDER.comment("Display stat bar for swords").worldRestart().define("swordStat", true);
            toolStat = BUILDER.comment("Display stat bar for tools").worldRestart().define("toolStat", true);
            armorStat = BUILDER.comment("Display stat bar for armor").worldRestart().define("armorStat", true);
            customStat = BUILDER.comment("Display custom stat bars").worldRestart().define("customStat", true);
            BUILDER.pop();
            BUILDER.comment("The following settings only affect Obscuria Collection Mods");
            BUILDER.push("Collection");
            BUILDER.push("General");
            collectionMaterials = BUILDER.comment("Display 'material' for crafting-only items").worldRestart().define("collectionMaterials", true);
            BUILDER.pop();
            BUILDER.push("Essentials");
            essentialsTips = BUILDER.comment("Display usage tips for some items").worldRestart().define("essentialsTips", true);
            essentialsTooltips = BUILDER.comment("Display common item descriptions").worldRestart().define("essentialsTooltips", true);
            BUILDER.pop();
            BUILDER.push("Aquamirae");
            aquamiraeTips = BUILDER.comment("Display usage tips for some items").worldRestart().define("aquamiraeTips", true);
            aquamiraeTooltips = BUILDER.comment("Display common item descriptions").worldRestart().define("aquamiraeTooltips", true);
            BUILDER.pop();
            BUILDER.pop();
            SPEC = BUILDER.build();
        }
    }
}

