/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.mushroomtower;

import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.TwilightForestMod;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerDecorator;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerPieces;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerWingComponent;
import twilightforest.world.components.structures.mushroomtower.TowerRoofMushroomComponent;
import twilightforest.world.registration.TFFeature;

public class MushroomTowerMainComponent
extends MushroomTowerWingComponent {
    public MushroomTowerMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(MushroomTowerPieces.TFMTMai, nbt);
    }

    public MushroomTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z) {
        this(feature, rand, index, x + 15, y + 4, z + 15, Direction.NORTH);
    }

    public MushroomTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z, Direction rotation) {
        super(MushroomTowerPieces.TFMTMai, feature, index, x, y, z, 15, 8 + rand.nextInt(3) * 4, rotation);
        if (this.deco == null) {
            this.deco = new MushroomTowerDecorator();
        }
    }

    protected MushroomTowerMainComponent(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(MushroomTowerPieces.TFMTMai, feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.hasBase = true;
        Rotation mainDir = null;
        if (this.m_73548_() < 3) {
            for (int i = 0; i < 6 && (mainDir = this.makeAscenderTower(list, rand)) == null; ++i) {
            }
            for (Rotation i : RotationUtil.ROTATIONS) {
                if (i == mainDir) continue;
                int[] dest = this.getValidOpening(rand, i);
                int childHeight = (rand.nextInt(2) + rand.nextInt(2) + 2) * 4 + 1;
                this.makeBridge(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, i);
            }
        } else {
            this.makeARoof(parent, list, rand);
        }
    }

    private Rotation makeAscenderTower(StructurePieceAccessor list, Random rand) {
        Rotation mainDir = RotationUtil.ROTATIONS[rand.nextInt(4)];
        int[] dest = this.getValidOpening(rand, mainDir);
        int childHeight = this.height - dest[1] + (rand.nextInt(2) + rand.nextInt(2) + 3) * 4 + 1;
        boolean madeIt = this.makeBridge(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, mainDir, true);
        if (madeIt) {
            TwilightForestMod.LOGGER.debug("Main tower made a bridge to another tower");
            return mainDir;
        }
        TwilightForestMod.LOGGER.info("Main tower failed to branch off at index {}", (Object)this.f_73384_);
        return null;
    }

    @Override
    public void makeARoof(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        TowerRoofMushroomComponent roof = new TowerRoofMushroomComponent(this.getFeatureType(), this.m_73548_() + 1, this, 1.6f, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)roof);
        roof.m_142537_(this, list, rand);
    }

    @Override
    protected void makeDoorOpening(WorldGenLevel world, int dx, int dy, int dz, BoundingBox sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (dx == 0) {
            this.m_73434_(world, AIR, dx + 1, dy, dz, sbb);
            this.m_73434_(world, AIR, dx + 1, dy + 1, dz, sbb);
        }
        if (dx == this.size - 1) {
            this.m_73434_(world, AIR, dx - 1, dy, dz, sbb);
            this.m_73434_(world, AIR, dx - 1, dy + 1, dz, sbb);
        }
        if (dz == 0) {
            this.m_73434_(world, AIR, dx, dy, dz + 1, sbb);
            this.m_73434_(world, AIR, dx, dy + 1, dz + 1, sbb);
        }
        if (dz == this.size - 1) {
            this.m_73434_(world, AIR, dx, dy, dz - 1, sbb);
            this.m_73434_(world, AIR, dx, dy + 1, dz - 1, sbb);
        }
    }
}

