/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import twilightforest.TwilightForestMod;
import twilightforest.loot.TFTreasure;
import twilightforest.world.components.feature.templates.TemplateFeature;
import twilightforest.world.components.processors.CobblePlankSwizzler;
import twilightforest.world.components.processors.CobbleVariants;
import twilightforest.world.components.processors.SmartGrassProcessor;

public class SimpleWellFeature
extends TemplateFeature<NoneFeatureConfiguration> {
    private static final ResourceLocation WELL_TOP = TwilightForestMod.prefix("feature/well/simple_well_top");
    private static final ResourceLocation WELL_BOTTOM = TwilightForestMod.prefix("feature/well/simple_well_bottom");

    public SimpleWellFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    @Override
    @Nullable
    protected StructureTemplate getTemplate(StructureManager templateManager, Random random) {
        return templateManager.m_74341_(WELL_TOP);
    }

    @Override
    protected int yLevelOffset() {
        return 1;
    }

    @Override
    protected void modifySettings(StructurePlaceSettings settings, Random random) {
        settings.m_74383_((StructureProcessor)new CobblePlankSwizzler(random)).m_74383_((StructureProcessor)CobbleVariants.INSTANCE);
    }

    @Override
    protected void postPlacement(WorldGenLevel world, Random random, StructureManager templateManager, Rotation rotation, Mirror mirror, StructurePlaceSettings placementSettings, BlockPos placementPos) {
        StructureTemplate template = templateManager.m_74341_(WELL_BOTTOM);
        if (template == null) {
            return;
        }
        placementPos = placementPos.m_6625_(template.m_163801_().m_123342_());
        placementSettings.m_74383_((StructureProcessor)SmartGrassProcessor.INSTANCE);
        template.m_74536_((ServerLevelAccessor)world, placementPos, placementPos, placementSettings, random, 20);
        for (StructureTemplate.StructureBlockInfo info : template.m_74603_(placementPos, placementSettings, Blocks.f_50677_)) {
            if (info.f_74677_ == null || StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
            this.processMarkers(info, world, rotation, mirror, random);
        }
    }

    @Override
    protected void processMarkers(StructureTemplate.StructureBlockInfo info, WorldGenLevel world, Rotation rotation, Mirror mirror, Random random) {
        String s = info.f_74677_.m_128461_("metadata");
        BlockPos blockPos = info.f_74675_;
        if (!s.startsWith("loot")) {
            return;
        }
        if (random.nextBoolean()) {
            world.m_7731_(blockPos, random.nextBoolean() ? Blocks.f_50652_.m_49966_() : Blocks.f_50079_.m_49966_(), 18);
            return;
        }
        world.m_7471_(blockPos, false);
        Direction dir = switch (s.substring(4, 5)) {
            case "W" -> rotation.m_55954_(mirror.m_54848_(Direction.WEST));
            case "E" -> rotation.m_55954_(mirror.m_54848_(Direction.EAST));
            case "S" -> rotation.m_55954_(mirror.m_54848_(Direction.SOUTH));
            default -> rotation.m_55954_(mirror.m_54848_(Direction.NORTH));
        };
        TFTreasure.WELL.generateLootContainer(world, blockPos, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)dir), 18);
        if (random.nextBoolean()) {
            return;
        }
        world.m_7731_(blockPos.m_142300_(dir), (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)dir.m_122424_()), 18);
    }
}

