/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.entity.TFEntities;
import twilightforest.entity.projectile.TomeBolt;
import twilightforest.loot.TFTreasure;

public class DeathTome
extends Monster
implements RangedAttackMob {
    public DeathTome(EntityType<? extends DeathTome> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 100, 5.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vel = this.m_20184_();
        if (!this.m_20096_() && vel.m_7098_() < 0.0) {
            this.m_20256_(vel.m_82542_(1.0, 0.6, 1.0));
        }
        for (int i = 0; i < 1; ++i) {
            this.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + (this.m_21187_().nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.m_21187_().nextDouble() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + (this.m_21187_().nextDouble() - 0.5) * (double)this.m_20205_(), 0.0, 0.5, 0.0);
        }
    }

    public boolean m_142535_(float dist, float mult, DamageSource source) {
        return false;
    }

    protected void m_7840_(double dist, boolean damage, BlockState state, BlockPos pos) {
        this.f_19789_ = 0.0f;
        super.m_7840_(dist, damage, state, pos);
    }

    public boolean m_6469_(DamageSource src, float damage) {
        if (src.m_19384_()) {
            damage *= 2.0f;
        }
        if (super.m_6469_(src, damage)) {
            if (damage > 0.0f && !this.m_183503_().m_5776_()) {
                LootContext ctx = this.m_7771_(true, src).m_78975_(LootContextParamSets.f_81415_);
                Objects.requireNonNull(this.m_183503_().m_142572_()).m_129898_().m_79217_(TFTreasure.DEATH_TOME_HURT).m_79148_(ctx, s -> this.m_5552_((ItemStack)s, 1.0f));
            }
            return true;
        }
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return TFSounds.TOME_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.TOME_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.TOME_DEATH;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        TomeBolt projectile = new TomeBolt((EntityType<? extends TomeBolt>)((EntityType)TFEntities.TOME_BOLT.get()), this.f_19853_, (LivingEntity)this);
        double tx = target.m_20185_() - this.m_20185_();
        double ty = target.m_20186_() + (double)target.m_20192_() - 1.1 - projectile.m_20186_();
        double tz = target.m_20189_() - this.m_20189_();
        float heightOffset = Mth.m_14116_((float)((float)(tx * tx + tz * tz))) * 0.2f;
        projectile.m_6686_(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.m_183503_().m_7967_((Entity)projectile);
    }
}

