/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.monster.LichMinion;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.item.TFItems;

public class LichMinionsGoal
extends Goal {
    private final Lich lich;

    public LichMinionsGoal(Lich boss) {
        this.lich = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.lich.getPhase() == 2 && !this.lich.isShadowClone();
    }

    public void m_8056_() {
        this.lich.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.ZOMBIE_SCEPTER.get()));
    }

    public void m_8037_() {
        LivingEntity targetedEntity = this.lich.m_5448_();
        if (targetedEntity == null) {
            return;
        }
        float dist = this.lich.m_20270_((Entity)targetedEntity);
        if (this.lich.getAttackCooldown() % 15 == 0) {
            this.checkAndSpawnMinions();
        }
        if (this.lich.getAttackCooldown() == 0) {
            if (dist < 2.0f) {
                this.lich.m_7327_((Entity)targetedEntity);
                this.lich.setAttackCooldown(20);
            } else if (dist < 20.0f && this.lich.m_21574_().m_148306_((Entity)targetedEntity)) {
                if (this.lich.getNextAttackType() == 0) {
                    this.lich.launchProjectileAt(new LichBolt(this.lich.m_183503_(), (LivingEntity)this.lich));
                } else {
                    this.lich.launchProjectileAt(new LichBomb(this.lich.m_183503_(), (LivingEntity)this.lich));
                }
                this.lich.m_6674_(InteractionHand.MAIN_HAND);
                this.lich.setNextAttackType(this.lich.m_21187_().nextBoolean() ? 0 : 1);
                this.lich.setAttackCooldown(60);
            } else {
                this.lich.teleportToSightOfEntity((Entity)targetedEntity);
                this.lich.setAttackCooldown(20);
            }
        }
    }

    private void checkAndSpawnMinions() {
        int minions;
        if (!this.lich.m_183503_().m_5776_() && this.lich.getMinionsToSummon() > 0 && (minions = this.lich.countMyMinions()) < 3) {
            this.spawnMinionAt();
            this.lich.setMinionsToSummon(this.lich.getMinionsToSummon() - 1);
        }
    }

    private void spawnMinionAt() {
        Level level;
        LivingEntity targetedEntity = this.lich.m_5448_();
        Vec3 minionSpot = this.lich.findVecInLOSOf((Entity)targetedEntity);
        if (minionSpot != null && (level = this.lich.m_183503_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            LichMinion minion = new LichMinion(this.lich.m_183503_(), this.lich);
            minion.m_6034_(minionSpot.f_82479_, minionSpot.f_82480_, minionSpot.f_82481_);
            minion.m_6518_(accessor, this.lich.m_183503_().m_6436_(new BlockPos(minionSpot)), MobSpawnType.MOB_SUMMONED, null, null);
            this.lich.m_183503_().m_7967_((Entity)minion);
            minion.m_6710_(targetedEntity);
            minion.m_21373_();
            minion.m_5496_(TFSounds.MINION_SUMMON, 1.0f, ((this.lich.m_21187_().nextFloat() - this.lich.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.lich.m_6674_(InteractionHand.MAIN_HAND);
            this.lich.makeMagicTrail(this.lich.m_146901_(), minion.m_146901_(), 0.0f, 0.0f, 0.0f);
        }
    }
}

