/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.MobSpawnSettings;
import twilightforest.command.TFCommand;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class InfoCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").requires(cs -> cs.m_6761_(2))).executes(InfoCommand::run);
    }

    private static int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!TFGenerationSettings.usesTwilightChunkGenerator(source.m_81372_())) {
            throw TFCommand.NOT_IN_TF.create();
        }
        BlockPos pos = new BlockPos(source.m_81371_());
        BlockPos cc = TFFeature.getNearestCenterXYZ(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        TFFeature closestFeature = TFFeature.getFeatureAt(cc.m_123341_(), cc.m_123343_(), (WorldGenLevel)source.m_81372_());
        source.m_81354_((Component)new TranslatableComponent("This command is still WIP, some things may still be broken.").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
        String structurename = new TranslatableComponent("structure." + closestFeature.name).getString();
        source.m_81354_((Component)new TranslatableComponent("commands.tffeature.nearest", new Object[]{structurename}), false);
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((LevelAccessor)source.m_81372_());
        if (chunkGenerator != null) {
            TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)source.m_81372_(), closestFeature, pos, 0).map(s -> (TFStructureStart)((Object)s)).ifPresent(structure -> {
                source.m_81354_((Component)new TranslatableComponent("commands.tffeature.structure.inside").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), false);
                source.m_81354_((Component)new TranslatableComponent("commands.tffeature.structure.conquer.status", new Object[]{structure.isConquered()}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, structure.isConquered() ? ChatFormatting.GREEN : ChatFormatting.RED}), false);
                List<MobSpawnSettings.SpawnerData> spawnList = TFStructureStart.gatherPotentialSpawns(source.m_81372_().m_8595_(), MobCategory.MONSTER, pos);
                source.m_81354_((Component)new TranslatableComponent("commands.tffeature.structure.spawn_list").m_130940_(ChatFormatting.UNDERLINE), false);
                if (spawnList != null) {
                    for (MobSpawnSettings.SpawnerData entry : spawnList) {
                        source.m_81354_((Component)new TranslatableComponent("commands.tffeature.structure.spawn_info", new Object[]{entry.f_48404_.m_20676_().getString(), entry.m_142631_().m_146281_()}), false);
                    }
                }
            });
        } else {
            source.m_81354_((Component)new TranslatableComponent("commands.tffeature.structure.outside").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), false);
        }
        return 1;
    }
}

