/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import twilightforest.entity.monster.GiantMiner;

public class TFGiantRenderer<T extends GiantMiner>
extends MobRenderer<T, PlayerModel<T>> {
    private final PlayerModel<T> normalModel = (PlayerModel)this.m_7200_();
    private final PlayerModel<T> slimModel;

    public TFGiantRenderer(EntityRendererProvider.Context manager) {
        super(manager, (EntityModel)new PlayerModel(manager.m_174023_(ModelLayers.f_171162_), false), 1.8f);
        this.slimModel = new PlayerModel(manager.m_174023_(ModelLayers.f_171166_), true);
        this.m_115326_(new GiantItemInHandLayer(this));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(manager.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(manager.m_174023_(ModelLayers.f_171165_))));
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (((PlayerModel)this.f_115290_).f_102609_) {
            matrixStackIn.m_85837_(0.0, -2.5, 0.0);
        }
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(GiantMiner entity) {
        Minecraft mc = Minecraft.m_91087_();
        boolean slim = false;
        ResourceLocation texture = DefaultPlayerSkin.m_118626_();
        Entity entity2 = mc.m_91288_();
        if (entity2 instanceof AbstractClientPlayer) {
            AbstractClientPlayer client = (AbstractClientPlayer)entity2;
            texture = client.m_108560_();
            slim = client.m_108564_().equals("slim");
        }
        this.f_115290_ = slim ? this.slimModel : this.normalModel;
        return texture;
    }

    public void scale(T entitylivingbaseIn, PoseStack stack, float partialTickTime) {
        float scale = 4.0f;
        stack.m_85841_(scale, scale, scale);
    }

    public static class GiantItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        public GiantItemInHandLayer(RenderLayerParent<T, M> parent) {
            super(parent);
        }

        public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack1;
            boolean flag = entity.m_5737_() == HumanoidArm.RIGHT;
            ItemStack itemstack = flag ? entity.m_21206_() : entity.m_21205_();
            ItemStack itemStack = itemstack1 = flag ? entity.m_21205_() : entity.m_21206_();
            if (!itemstack.m_41619_() || !itemstack1.m_41619_()) {
                stack.m_85836_();
                if (this.m_117386_().f_102610_) {
                    stack.m_85837_(0.0, 0.75, 0.0);
                    stack.m_85841_(0.5f, 0.5f, 0.5f);
                }
                this.renderArmWithItem((LivingEntity)entity, itemstack1, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, stack, buffer, light);
                this.renderArmWithItem((LivingEntity)entity, itemstack, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, stack, buffer, light);
                stack.m_85849_();
            }
        }

        protected void renderArmWithItem(LivingEntity entity, ItemStack stack, ItemTransforms.TransformType type, HumanoidArm arm, PoseStack ms, MultiBufferSource buffer, int light) {
            if (!stack.m_41619_()) {
                ms.m_85836_();
                ((ArmedModel)this.m_117386_()).m_6002_(arm, ms);
                ms.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                boolean flag = arm == HumanoidArm.LEFT;
                ms.m_85837_((double)((float)(flag ? -1 : 1) / 16.0f), 0.0, -0.5);
                ms.m_85841_(0.25f, 0.25f, 0.25f);
                Minecraft.m_91087_().m_91292_().m_109322_(entity, stack, type, flag, ms, buffer, light);
                ms.m_85849_();
            }
        }
    }
}

