/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.IWeatherRenderHandler;
import twilightforest.TwilightForestMod;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TFWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation SPARKLES_TEXTURE = TwilightForestMod.getEnvTexture("sparkles.png");
    private final float[] rainxs = new float[1024];
    private final float[] rainzs = new float[1024];
    private int rendererUpdateCount;
    private BoundingBox protectedBox;
    private final Random random = new Random();

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f * f + f1 * f1));
                this.rainxs[i << 5 | j] = -f1 / f2;
                this.rainzs[i << 5 | j] = f / f2;
            }
        }
    }

    public void tick() {
        ++this.rendererUpdateCount;
    }

    public void render(int ticks, float partialTicks, ClientLevel world, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        this.renderNormalWeather(lightmap, world, mc, partialTicks, xIn, yIn, zIn);
        if (TFGenerationSettings.isProgressionEnforced((Level)world) && !mc.f_91074_.m_7500_() && !mc.f_91074_.m_5833_()) {
            this.renderLockedBiome(partialTicks, world, mc, lightmap, xIn, yIn, zIn);
            this.renderLockedStructure(partialTicks, mc, lightmap, xIn, yIn, zIn);
        }
    }

    private void renderNormalWeather(LightTexture lightmap, ClientLevel world, Minecraft mc, float ticks, double x, double y, double z) {
        float f = Minecraft.m_91087_().f_91073_.m_46722_(ticks);
        if (!(f <= 0.0f)) {
            lightmap.m_109896_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            int i = Mth.m_14107_((double)x);
            int j = Mth.m_14107_((double)y);
            int k = Mth.m_14107_((double)z);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int l = 5;
            if (Minecraft.m_91405_()) {
                l = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int i1 = -1;
            float f1 = (float)this.rendererUpdateCount + ticks;
            RenderSystem.m_157427_(GameRenderer::m_172829_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainxs[l1] * 0.5;
                    double d1 = (double)this.rainzs[l1] * 0.5;
                    blockpos$mutableblockpos.m_122178_(k1, 0, j1);
                    Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                    if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                    int i2 = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).m_123342_();
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    Random random = new Random((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L);
                    blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                    float f2 = biome.m_47505_((BlockPos)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 0;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)RAIN_TEXTURES);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        int i3 = this.rendererUpdateCount + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + ticks) / 32.0f * (3.0f + random.nextFloat());
                        double d2 = (double)k1 + 0.5 - x;
                        double d4 = (double)j1 + 0.5 - z;
                        float f4 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f3).m_85950_(1.0f, 1.0f, 1.0f, f5).m_85969_(j3).m_5752_();
                        continue;
                    }
                    if (i1 != 1) {
                        if (i1 >= 0) {
                            tesselator.m_85914_();
                        }
                        i1 = 1;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)SNOW_TEXTURES);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float f6 = -((float)(this.rendererUpdateCount & 0x1FF) + ticks) / 512.0f;
                    float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
                    float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
                    double d3 = (double)k1 + 0.5 - x;
                    double d5 = (double)j1 + 0.5 - z;
                    float f9 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                    int k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                    int l3 = k3 >> 16 & 0xFFFF;
                    int i4 = k3 & 0xFFFF;
                    int j4 = (l3 * 3 + 240) / 4;
                    int k4 = (i4 * 3 + 240) / 4;
                    bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)k2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)k2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x + d0 + 0.5, (double)j2 - y, (double)j1 - z + d1 + 0.5).m_7421_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                    bufferbuilder.m_5483_((double)k1 - x - d0 + 0.5, (double)j2 - y, (double)j1 - z - d1 + 0.5).m_7421_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).m_85950_(1.0f, 1.0f, 1.0f, f10).m_7120_(k4, j4).m_5752_();
                }
            }
            if (i1 >= 0) {
                tesselator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmap.m_109891_();
        }
    }

    private void renderLockedBiome(float partialTicks, ClientLevel wc, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        if (this.isNearLockedBiome((Level)wc, mc.m_91288_())) {
            lightmap.m_109896_();
            Entity entity = mc.m_91288_();
            ClientLevel world = mc.f_91073_;
            int x0 = Mth.m_14107_((double)xIn);
            int y0 = Mth.m_14107_((double)yIn);
            int z0 = Mth.m_14107_((double)zIn);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int range = 5;
            if (Minecraft.m_91405_()) {
                range = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            Enum currentType = null;
            float combinedTicks = (float)this.rendererUpdateCount + partialTicks;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int z = z0 - range; z <= z0 + range; ++z) {
                block7: for (int x = x0 - range; x <= x0 + range; ++x) {
                    int idx = (z - z0 + 16) * 32 + x - x0 + 16;
                    double rx = (double)this.rainxs[idx] * 0.5;
                    double ry = (double)this.rainzs[idx] * 0.5;
                    blockpos$mutableblockpos.m_122178_(x, 0, z);
                    Biome biome = (Biome)world.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                    if (TFGenerationSettings.isBiomeSafeFor(biome, entity)) continue;
                    int groundY = 0;
                    int minY = y0 - range;
                    int maxY = y0 + range;
                    if (minY < groundY) {
                        minY = groundY;
                    }
                    if (maxY < groundY) {
                        maxY = groundY;
                    }
                    int y = Math.max(groundY, y0);
                    if (minY == maxY) continue;
                    this.random.setSeed((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L);
                    RenderType nextType = this.getRenderType(biome);
                    if (nextType == null) continue;
                    if (currentType != nextType) {
                        if (currentType != null) {
                            tessellator.m_85914_();
                        }
                        currentType = nextType;
                        RenderSystem.m_157179_((int)0, (ResourceLocation)nextType.getTextureLocation());
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    switch (1.$SwitchMap$twilightforest$client$renderer$TFWeatherRenderer$RenderType[currentType.ordinal()]) {
                        case 1: 
                        case 2: {
                            float d5 = -((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                            double d6 = (double)((float)x + 0.5f) - xIn;
                            double d7 = (double)((float)z + 0.5f) - zIn;
                            float f3 = Mth.m_14116_((float)((float)(d6 * d6 + d7 * d7))) / (float)range;
                            float f4 = (1.0f - f3 * f3) * 0.5f + 0.5f;
                            blockpos$mutableblockpos.m_122178_(x, y, z);
                            int j3 = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)blockpos$mutableblockpos);
                            int k3 = j3 >> 16 & 0xFFFF;
                            int l3 = j3 & 0xFFFF;
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f, (float)minY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f, (float)minY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f, (float)maxY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f, (float)maxY * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                            continue block7;
                        }
                        case 3: {
                            float d8 = 0.0f;
                            float d9 = this.random.nextFloat() + combinedTicks * 0.01f * (float)this.random.nextGaussian();
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float r = this.random.nextFloat() * 0.3f;
                            float g = this.random.nextFloat() * 0.3f;
                            float b = this.random.nextFloat() * 0.3f;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(r, g, b, f5).m_7120_(j4, k4).m_5752_();
                            continue block7;
                        }
                        case 4: {
                            float d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = this.random.nextFloat() + combinedTicks * 0.01f * (float)this.random.nextGaussian();
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = (1.0f - f6 * f6) * 0.3f + 0.5f;
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            float color = this.random.nextFloat() * 0.2f + 0.8f;
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(color, color, color, f5).m_7120_(j4, k4).m_5752_();
                            continue block7;
                        }
                        case 5: {
                            float d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                            float d9 = 0.0f;
                            float d10 = this.random.nextFloat() + combinedTicks * (float)this.random.nextGaussian() * 0.001f;
                            double d11 = (double)((float)x + 0.5f) - xIn;
                            double d12 = (double)((float)z + 0.5f) - zIn;
                            float f6 = Mth.m_14116_((float)((float)(d11 * d11 + d12 * d12))) / (float)range;
                            float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * this.random.nextFloat();
                            int i4 = 0xF000F0;
                            int j4 = i4 >> 16 & 0xFFFF;
                            int k4 = i4 & 0xFFFF;
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)maxY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)maxY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)minY * 0.25f + d8 + d10).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn + rx + 0.5, (double)minY - yIn, (double)z - zIn + ry + 0.5).m_7421_(1.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                            bufferbuilder.m_5483_((double)x - xIn - rx + 0.5, (double)minY - yIn, (double)z - zIn - ry + 0.5).m_7421_(0.0f + d9, (float)maxY * 0.25f + d8 + d10).m_85950_(1.0f, 1.0f, 1.0f, f5).m_7120_(j4, k4).m_5752_();
                        }
                    }
                }
            }
            if (currentType != null) {
                tessellator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmap.m_109891_();
        }
    }

    private void renderLockedStructure(float partialTicks, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        if (this.isNearLockedStructure(xIn, zIn)) {
            lightmap.m_109896_();
            int i = Mth.m_14107_((double)xIn);
            int j = Mth.m_14107_((double)yIn);
            int k = Mth.m_14107_((double)zIn);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_69464_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int i1 = 5;
            if (Minecraft.m_91405_()) {
                i1 = 10;
            }
            RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
            int j1 = -1;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainzs[i2] * 0.5;
                    if (this.protectedBox == null || !this.protectedBox.m_71019_(l1, k1, l1, k1)) continue;
                    int structureMin = this.protectedBox.m_162396_() - 4;
                    int structureMax = this.protectedBox.m_162400_() + 4;
                    int k2 = j - i1;
                    int l2 = j + i1 * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    Random random = new Random((long)l1 * (long)l1 * 3121L + (long)l1 * 45238971L ^ (long)k1 * (long)k1 * 418711L + (long)k1 * 13761L);
                    blockpos$mutableblockpos.m_122178_(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.m_85914_();
                        }
                        j1 = 0;
                        RenderSystem.m_157179_((int)0, (ResourceLocation)SPARKLES_TEXTURE);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    }
                    float d5 = -((float)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                    double d6 = (double)((float)l1 + 0.5f) - xIn;
                    double d7 = (double)((float)k1 + 0.5f) - zIn;
                    float f3 = Mth.m_14116_((float)((float)(d6 * d6 + d7 * d7))) / (float)i1;
                    float f = random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    bufferbuilder.m_5483_((double)l1 - xIn - d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn - d4 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn + d3 + 0.5, (double)l2 - yIn, (double)k1 - zIn + d4 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn + d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn + d4 + 0.5).m_7421_(1.0f, (float)l2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                    bufferbuilder.m_5483_((double)l1 - xIn - d3 + 0.5, (double)k2 - yIn, (double)k1 - zIn - d4 + 0.5).m_7421_(0.0f, (float)l2 * 0.25f + d5).m_85950_(1.0f, 1.0f, 1.0f, f4).m_7120_(k3, l3).m_5752_();
                }
            }
            if (j1 >= 0) {
                tessellator.m_85914_();
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            lightmap.m_109891_();
        }
    }

    private boolean isNearLockedBiome(Level world, Entity viewEntity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int range = 15;
        int px = Mth.m_14107_((double)viewEntity.m_20185_());
        int pz = Mth.m_14107_((double)viewEntity.m_20189_());
        for (int z = pz - 15; z <= pz + 15; ++z) {
            for (int x = px - 15; x <= px + 15; ++x) {
                Biome biome = (Biome)world.m_204166_((BlockPos)pos.m_122178_(x, 0, z)).m_203334_();
                if (TFGenerationSettings.isBiomeSafeFor(biome, viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearLockedStructure(double xIn, double zIn) {
        int range = 15;
        int px = Mth.m_14107_((double)xIn);
        int pz = Mth.m_14107_((double)zIn);
        return this.protectedBox != null && this.protectedBox.m_71019_(px - 15, pz - 15, px + 15, pz + 15);
    }

    public void setProtectedBox(BoundingBox protectedBox) {
        this.protectedBox = protectedBox;
    }

    private RenderType getRenderType(Biome b) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        ResourceLocation biome = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)b);
        if (BiomeKeys.SNOWY_FOREST.m_135782_().equals((Object)biome) || BiomeKeys.GLACIER.m_135782_().equals((Object)biome)) {
            return RenderType.BLIZZARD;
        }
        if (BiomeKeys.SWAMP.m_135782_().equals((Object)biome)) {
            return RenderType.MOSQUITO;
        }
        if (BiomeKeys.FIRE_SWAMP.m_135782_().equals((Object)biome)) {
            return RenderType.ASHES;
        }
        if (BiomeKeys.DARK_FOREST.m_135782_().equals((Object)biome) || BiomeKeys.DARK_FOREST_CENTER.m_135782_().equals((Object)biome)) {
            return this.random.nextInt(2) == 0 ? RenderType.DARK_STREAM : null;
        }
        if (BiomeKeys.HIGHLANDS.m_135782_().equals((Object)biome) || BiomeKeys.THORNLANDS.m_135782_().equals((Object)biome) || BiomeKeys.FINAL_PLATEAU.m_135782_().equals((Object)biome)) {
            return RenderType.BIG_RAIN;
        }
        return null;
    }

    private static enum RenderType {
        BLIZZARD("blizzard.png"),
        MOSQUITO("mosquitoes.png"),
        ASHES("ashes.png"),
        DARK_STREAM("darkstream.png"),
        BIG_RAIN("bigrain.png");

        private final ResourceLocation textureLocation;

        private RenderType(String textureName) {
            this.textureLocation = TwilightForestMod.getEnvTexture(textureName);
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }
    }
}

