/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pehkuiresizer.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.pehkuiresizer.PehkuiResizerMod;
import net.mcreator.pehkuiresizer.procedures.AddButtonEntitiesProcedure;
import net.mcreator.pehkuiresizer.procedures.ChangeAmountEntitiesProcedure;
import net.mcreator.pehkuiresizer.procedures.ResizeSelfProcedure;
import net.mcreator.pehkuiresizer.procedures.Set2pxEntitiesProcedure;
import net.mcreator.pehkuiresizer.procedures.SetResetEntitiesProcedure;
import net.mcreator.pehkuiresizer.procedures.SubtractButtonEntitiesProcedure;
import net.mcreator.pehkuiresizer.world.inventory.ResizerEntitiesMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResizerEntitiesButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ResizerEntitiesButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ResizerEntitiesButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ResizerEntitiesButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ResizerEntitiesButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ResizerEntitiesButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = ResizerEntitiesMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Set2pxEntitiesProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SetResetEntitiesProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ResizeSelfProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            AddButtonEntitiesProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SubtractButtonEntitiesProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ChangeAmountEntitiesProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PehkuiResizerMod.addNetworkMessage(ResizerEntitiesButtonMessage.class, ResizerEntitiesButtonMessage::buffer, ResizerEntitiesButtonMessage::new, ResizerEntitiesButtonMessage::handler);
    }
}

