/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pehkuiresizer.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.pehkuiresizer.PehkuiResizerMod;
import net.mcreator.pehkuiresizer.procedures.AddBlockChannelProcedure;
import net.mcreator.pehkuiresizer.procedures.AddBlockSizeProcedure;
import net.mcreator.pehkuiresizer.procedures.BlockChangeAmountCycleProcedure;
import net.mcreator.pehkuiresizer.procedures.SetBlock2PXProcedure;
import net.mcreator.pehkuiresizer.procedures.SetBlockResetProcedure;
import net.mcreator.pehkuiresizer.procedures.SubtractBlockChannelProcedure;
import net.mcreator.pehkuiresizer.procedures.SubtractBlockSizeProcedure;
import net.mcreator.pehkuiresizer.world.inventory.RedstoneResizerGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RedstoneResizerGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RedstoneResizerGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RedstoneResizerGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RedstoneResizerGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RedstoneResizerGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RedstoneResizerGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = RedstoneResizerGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SetBlock2PXProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            SetBlockResetProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            AddBlockSizeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            AddBlockChannelProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            SubtractBlockSizeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            SubtractBlockChannelProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            BlockChangeAmountCycleProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PehkuiResizerMod.addNetworkMessage(RedstoneResizerGUIButtonMessage.class, RedstoneResizerGUIButtonMessage::buffer, RedstoneResizerGUIButtonMessage::new, RedstoneResizerGUIButtonMessage::handler);
    }
}

