/*
 * Decompiled with CFR 0.152.
 */
package com.github.epiicthundercat.hempfarmer.blocks.powerbattery;

import net.minecraftforge.common.ForgeConfigSpec;

public class PowerBatteryConfig {
    public static ForgeConfigSpec.IntValue POWER_BATTERY_CAPACITY;
    public static ForgeConfigSpec.IntValue POWER_BATTERY_GENERATE;
    public static ForgeConfigSpec.IntValue POWER_BATTERY_SEND;
    public static ForgeConfigSpec.DoubleValue RENDER_SCALE;

    public static void registerServerConfig(ForgeConfigSpec.Builder SERVER_BUILDER) {
        SERVER_BUILDER.comment("Settings for the power generator").push("powerbattery");
        POWER_BATTERY_CAPACITY = SERVER_BUILDER.comment("How much energy fits into the power battery").defineInRange("capacity", 50000, 1, Integer.MAX_VALUE);
        POWER_BATTERY_GENERATE = SERVER_BUILDER.comment("How much energy is generated by the power battery").defineInRange("generate", 60, 1, Integer.MAX_VALUE);
        POWER_BATTERY_SEND = SERVER_BUILDER.comment("How much energy the power generator will send out to adjacent blocks every tick").defineInRange("send", 200, 1, Integer.MAX_VALUE);
        SERVER_BUILDER.pop();
    }

    public static void registerClientConfig(ForgeConfigSpec.Builder CLIENT_BUILDER) {
        CLIENT_BUILDER.comment("Client settings for the power generator").push("powerbattery");
        RENDER_SCALE = CLIENT_BUILDER.comment("Scale of the renderer").defineInRange("scale", 0.3, 1.0E-6, 1000.0);
        CLIENT_BUILDER.pop();
    }
}

