/*
 * Decompiled with CFR 0.152.
 */
package com.github.epiicthundercat.hempfarmer.blocks.powerbattery;

import com.github.epiicthundercat.hempfarmer.setup.Registration;
import com.github.epiicthundercat.hempfarmer.util.HempFarmerEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PowerBatteryBE
extends BlockEntity {
    public static final int POWER_BATTERY_CAPACITY = 50000;
    public static final int POWER_BATTERY_GENERATE = 60;
    public static final int POWER_BATTERY_SEND = 200;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private final HempFarmerEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private int counter;

    public PowerBatteryBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.POWER_BATTERY_BE.get(), pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.energy.invalidate();
    }

    public void tickServer() {
        BlockState blockState;
        ItemStack stack;
        int burnTime;
        if (this.counter > 0) {
            this.energyStorage.addEnergy(60);
            --this.counter;
            this.m_6596_();
        }
        if (this.counter <= 0 && (burnTime = ForgeHooks.getBurnTime((ItemStack)(stack = this.itemHandler.getStackInSlot(0)), (RecipeType)RecipeType.f_44108_)) > 0) {
            this.itemHandler.extractItem(0, 1, false);
            this.counter = burnTime;
            this.m_6596_();
        }
        if ((Boolean)(blockState = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)BlockStateProperties.f_61448_) != this.counter > 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.counter > 0)), 3);
        }
        this.sendOutPower();
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                if (blockEntity == null || (doContinue = blockEntity.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 200), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Info")) {
            this.counter = tag.m_128469_("Info").m_128451_("Counter");
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128405_("Counter", this.counter);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                PowerBatteryBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) <= 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private HempFarmerEnergyStorage createEnergy() {
        return new HempFarmerEnergyStorage(50000, 0){

            @Override
            protected void onEnergyChanged() {
                PowerBatteryBE.this.m_6596_();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }
}

