/*
 * Decompiled with CFR 0.152.
 */
package com.github.epiicthundercat.hempfarmer.blocks.grinder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GrinderRecipeHandler
implements Recipe<CraftingContainer> {
    public static final RecipeType<GrinderRecipeHandler> TYPE = RecipeType.m_44119_((String)"grinder_recipe");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation ID;
    private final NonNullList<Ingredient> INPUTS;
    private final ItemStack OUTPUT;
    private final float XP;
    protected final int CRAFTTIME;
    private final boolean ISSIMPLE;

    public GrinderRecipeHandler(ResourceLocation id, NonNullList<Ingredient> inputStacks, ItemStack outputStack, float xp, int craftTime) {
        this.ID = id;
        this.INPUTS = inputStacks;
        this.OUTPUT = outputStack;
        this.XP = xp;
        this.CRAFTTIME = craftTime;
        this.ISSIMPLE = inputStacks.stream().allMatch(Ingredient::isSimple);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        StackedContents recipeItemHelper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 1; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.ISSIMPLE) {
                recipeItemHelper.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.INPUTS.size() && (this.ISSIMPLE ? recipeItemHelper.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.INPUTS) != null);
    }

    public ItemStack assemble(CraftingContainer pContainer) {
        return this.OUTPUT.m_41777_();
    }

    public boolean matches(ItemStackHandler inv) {
        StackedContents recipeHelper = new StackedContents();
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        int count = 0;
        for (int i = 0; i < 1; ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            ++count;
            if (this.ISSIMPLE) {
                recipeHelper.m_36468_(itemstack, 1);
                continue;
            }
            inputStacks.add(itemstack);
        }
        return count == this.INPUTS.size() && (this.ISSIMPLE ? recipeHelper.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputStacks, this.INPUTS) != null);
    }

    public ItemStack getOutput() {
        return this.OUTPUT.m_41777_();
    }

    public float getXP() {
        return this.XP;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.INPUTS;
    }

    public boolean m_5598_() {
        return this.ISSIMPLE;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.OUTPUT;
    }

    public ResourceLocation m_6423_() {
        return this.ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public int getCraftTime() {
        return this.CRAFTTIME;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<GrinderRecipeHandler> {
        public GrinderRecipeHandler fromJson(ResourceLocation recipeId, JsonObject json) {
            try {
                NonNullList inputStacks = NonNullList.m_122779_();
                for (int i = 0; i < GsonHelper.m_13933_((JsonObject)json, (String)"ingredients").size(); ++i) {
                    Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredients").get(i));
                    if (ingredient.m_43947_()) continue;
                    inputStacks.add((Object)ingredient);
                }
                if (inputStacks.isEmpty()) {
                    throw new JsonParseException("No ingredients for Grinder recipe.");
                }
                if (inputStacks.size() > 3) {
                    throw new JsonParseException("Too many ingredients for Grinder recipe, the max is 1.");
                }
                ItemStack outputStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
                float xp = GsonHelper.m_13915_((JsonObject)json, (String)"xp");
                int craftTime = GsonHelper.m_13927_((JsonObject)json, (String)"craft_time");
                return new GrinderRecipeHandler(recipeId, (NonNullList<Ingredient>)inputStacks, outputStack, xp, craftTime);
            }
            catch (JsonSyntaxException e) {
                return null;
            }
        }

        public GrinderRecipeHandler fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int inputSize = buffer.m_130242_();
            NonNullList inputStacks = NonNullList.m_122780_((int)inputSize, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputStacks.size(); ++i) {
                inputStacks.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            float xp = buffer.readFloat();
            int craftTime = buffer.readInt();
            ItemStack outputStack = buffer.m_130267_();
            return new GrinderRecipeHandler(recipeId, (NonNullList<Ingredient>)inputStacks, outputStack, xp, craftTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, GrinderRecipeHandler recipe) {
            buffer.m_130130_(recipe.INPUTS.size());
            for (Ingredient ingredient : recipe.INPUTS) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeFloat(recipe.XP);
            buffer.writeInt(recipe.CRAFTTIME);
            buffer.m_130055_(recipe.OUTPUT);
        }
    }
}

