/*
 * Decompiled with CFR 0.152.
 */
package com.github.epiicthundercat.hempfarmer.blocks.grinder;

import com.github.epiicthundercat.hempfarmer.blocks.grinder.GrinderBE;
import com.github.epiicthundercat.hempfarmer.setup.Registration;
import com.github.epiicthundercat.hempfarmer.util.HempFarmerEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GrinderContainer
extends AbstractContainerMenu {
    private final GrinderBE blockEntity;
    protected final Level level;
    private final ContainerData data;
    private final Player playerEntity;
    private final IItemHandler playerInventory;

    public GrinderContainer(int ID, BlockPos pos, Inventory playerInventory, Player playerIn) {
        this(ID, pos, playerInventory, playerIn, (ContainerData)new SimpleContainerData(2));
    }

    public GrinderContainer(int ID, BlockPos pos, Inventory playerInventory, Player player, ContainerData blockData) {
        super((MenuType)Registration.GRINDER_CONTAINER.get(), ID);
        GrinderContainer.m_38886_((ContainerData)blockData, (int)2);
        this.blockEntity = (GrinderBE)player.m_20193_().m_7702_(pos);
        this.playerEntity = player;
        this.level = playerInventory.f_35978_.f_19853_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.data = blockData;
        if (this.blockEntity != null) {
            this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                this.m_38897_((Slot)new SlotItemHandler(h, this.blockEntity.SLOT_INPUT_1, 46, 31));
                this.m_38897_((Slot)new SlotItemHandler(h, this.blockEntity.SLOT_OUTPUT_1, 118, 31));
            });
        }
        this.layoutPlayerInventorySlots(10, 70);
        this.trackPower();
    }

    public GrinderBE getBE() {
        return this.blockEntity;
    }

    private void trackPower() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GrinderContainer.this.getEnergy() & 0xFFFF;
            }

            public void m_6422_(int value) {
                GrinderContainer.this.blockEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF0000;
                    ((HempFarmerEnergyStorage)((Object)h)).setEnergy(energyStored + (value & 0xFFFF));
                });
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GrinderContainer.this.getEnergy() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                GrinderContainer.this.blockEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF;
                    ((HempFarmerEnergyStorage)((Object)h)).setEnergy(energyStored | value << 16);
                });
            }
        });
    }

    public int getGrindTime() {
        return this.data.m_6413_(0);
    }

    public int getGrindLength() {
        return this.data.m_6413_(1);
    }

    public int getEnergy() {
        return this.blockEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public boolean m_6875_(Player playerIn) {
        return GrinderContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)Registration.GRINDER.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(stack, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else {
                if (!this.m_38903_(stack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (index < 28 ? !this.m_38903_(stack, 28, 37, false) : index < 37 && !this.m_38903_(stack, 1, 28, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }
}

