/*
 * Decompiled with CFR 0.152.
 */
package com.github.epiicthundercat.hempfarmer.blocks.grinder;

import com.github.epiicthundercat.hempfarmer.blocks.grinder.GrinderBlock;
import com.github.epiicthundercat.hempfarmer.blocks.grinder.GrinderConfig;
import com.github.epiicthundercat.hempfarmer.blocks.grinder.GrinderContainer;
import com.github.epiicthundercat.hempfarmer.blocks.grinder.GrinderRecipeHandler;
import com.github.epiicthundercat.hempfarmer.setup.Registration;
import com.github.epiicthundercat.hempfarmer.util.HempFarmerEnergyStorage;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GrinderBE
extends BlockEntity {
    private final HempFarmerEnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energy);
    public final int SLOT_INPUT_1 = 0;
    public final int SLOT_OUTPUT_1 = 1;
    private int grindTime = -1;
    private int grindLength = -1;
    private float xp = 0.0f;
    private int counter;
    protected final ContainerData blockData = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> GrinderBE.this.grindTime;
                case 1 -> GrinderBE.this.grindLength;
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            switch (id) {
                case 0: {
                    GrinderBE.this.grindTime = value;
                    break;
                }
                case 1: {
                    GrinderBE.this.grindLength = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int playersInside;
    protected final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            GrinderBE.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < 1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1 && !simulate && (int)GrinderBE.this.xp > 0) {
                GrinderBE.this.m_58904_().m_7967_((Entity)new ExperienceOrb(GrinderBE.this.m_58904_(), (double)((float)GrinderBE.this.m_58899_().m_123341_() + 0.5f), (double)(GrinderBE.this.m_58899_().m_123342_() + 1), (double)((float)GrinderBE.this.m_58899_().m_123343_() + 0.5f), (int)GrinderBE.this.getXP()));
                GrinderBE.this.setXP(GrinderBE.this.getXP() - (float)((int)GrinderBE.this.getXP()));
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private final LazyOptional<IItemHandler> items = LazyOptional.of(() -> this.itemHandler);
    private final IItemHandler hopperhandler = new IItemHandler(){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return GrinderBE.this.itemHandler.isItemValid(slot, stack);
        }

        public int getSlots() {
            return GrinderBE.this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return GrinderBE.this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return GrinderBE.this.itemHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < 1) {
                return ItemStack.f_41583_;
            }
            return GrinderBE.this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return GrinderBE.this.itemHandler.getSlotLimit(slot);
        }
    };
    private final LazyOptional<IItemHandler> hopper = LazyOptional.of(() -> this.hopperhandler);

    public void tickServer() {
        this.setPlayersInside(this.getPlayersInside());
        AtomicInteger capacity = new AtomicInteger(this.energy.getEnergyStored());
        if (!this.f_58857_.m_5776_()) {
            GrinderRecipeHandler recipe = this.canCraft();
            if (recipe != null) {
                int craftTimeXenergy = (Integer)GrinderConfig.ENERGY_NEED.get() * recipe.getCraftTime();
                if (capacity.get() > (Integer)GrinderConfig.ENERGY_NEED.get()) {
                    if (this.getGrindTime() > 0) {
                        int consumedEnergy = (Integer)GrinderConfig.ENERGY_NEED.get();
                        capacity.addAndGet(-consumedEnergy);
                        this.energy.consumeEnergy(consumedEnergy);
                        this.setGrindTime(this.getGrindTime() - 1);
                    } else {
                        if (this.getGrindTime() == 0) {
                            this.finishCraft(recipe);
                        }
                        if (this.getGrindTime() == -1 && this.getGrindLength() == -1 && capacity.get() >= craftTimeXenergy) {
                            this.startCraft(recipe);
                        }
                    }
                }
            } else {
                this.stopCrafting();
            }
        }
    }

    public GrinderRecipeHandler canCraft() {
        GrinderRecipeHandler recipe = this.getRecipeFromContents();
        if (this.energy.getEnergyStored() < (Integer)GrinderConfig.ENERGY_NEED.get()) {
            return null;
        }
        if (recipe != null) {
            if (this.itemHandler.getStackInSlot(1).m_41619_()) {
                return recipe;
            }
            ItemStack output = this.itemHandler.getStackInSlot(1);
            if (recipe.m_8043_().m_41720_() == output.m_41720_() && output.m_41753_() && output.m_41613_() + recipe.m_8043_().m_41613_() <= output.m_41741_()) {
                return recipe;
            }
        }
        return null;
    }

    public GrinderRecipeHandler getRecipeFromContents() {
        GrinderRecipeHandler toCraft = null;
        for (GrinderRecipeHandler recipe : this.f_58857_.m_7465_().m_44013_(GrinderRecipeHandler.TYPE)) {
            if (!recipe.matches(this.itemHandler)) continue;
            toCraft = recipe;
            break;
        }
        return toCraft;
    }

    public void startCraft(GrinderRecipeHandler recipe) {
        int totalEnergyForCraft = (Integer)GrinderConfig.ENERGY_NEED.get() * recipe.getCraftTime();
        if (this.energy.getEnergyStored() < totalEnergyForCraft) {
            this.stopCrafting();
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GrinderBlock.IS_ON, (Comparable)Boolean.valueOf(true)));
        this.setGrindLength(recipe.getCraftTime());
        this.setGrindTime(this.getGrindLength());
    }

    public void stopCrafting() {
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GrinderBlock.IS_ON, (Comparable)Boolean.valueOf(false)));
        this.setGrindLength(-1);
        this.setGrindTime(-1);
    }

    private void finishCraft(GrinderRecipeHandler recipe) {
        this.stopCrafting();
        HashMap<ItemStack, Boolean> inventoryItems = new HashMap<ItemStack, Boolean>();
        for (int slot = 0; slot < 1; ++slot) {
            inventoryItems.put(this.itemHandler.getStackInSlot(slot), false);
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            for (int slot = 0; slot < 1; ++slot) {
                if (!ingredient.test(this.itemHandler.getStackInSlot(slot)) || ((Boolean)inventoryItems.get(this.itemHandler.getStackInSlot(slot))).booleanValue()) continue;
                inventoryItems.remove(this.itemHandler.getStackInSlot(slot));
                inventoryItems.put(this.itemHandler.getStackInSlot(slot), true);
                this.itemHandler.getStackInSlot(slot).m_41774_(ingredient.m_43908_()[0].m_41613_());
            }
        }
        ItemStack output = this.itemHandler.getStackInSlot(1);
        if (output.m_41619_()) {
            this.itemHandler.setStackInSlot(1, recipe.getOutput());
        }
        if (output.m_41753_()) {
            ItemStack newOutput = recipe.getOutput();
            newOutput.m_41769_(output.m_41613_());
            this.itemHandler.setStackInSlot(1, newOutput);
        }
        this.setXP(this.getXP() + recipe.getXP());
    }

    public float getXP() {
        return this.xp;
    }

    public void setXP(float xp) {
        this.xp = xp;
        this.m_6596_();
    }

    public int getGrindTime() {
        return this.grindTime;
    }

    public void setGrindTime(int tick) {
        this.grindTime = tick;
        this.m_6596_();
    }

    public int getGrindLength() {
        return this.grindLength;
    }

    public void setGrindLength(int ticks) {
        this.grindLength = ticks;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128425_("CookTime", 3)) {
            this.grindTime = tag.m_128451_("CookTime");
        }
        if (tag.m_128425_("CookLength", 3)) {
            this.grindLength = tag.m_128451_("CookLength");
        }
        if (tag.m_128425_("XP", 5)) {
            this.xp = tag.m_128457_("XP");
        }
        if (tag.m_128441_("Info")) {
            this.counter = tag.m_128469_("Info").m_128451_("Counter");
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Energy", this.energy.serializeNBT());
        if (this.getGrindTime() != -1) {
            tag.m_128405_("CookTime", this.getGrindTime());
        }
        if (this.getGrindLength() != -1) {
            tag.m_128405_("CookLength", this.getGrindTime());
        }
        if (this.getXP() != 0.0f) {
            tag.m_128350_("XP", this.getXP());
        }
        CompoundTag infoTag = new CompoundTag();
        infoTag.m_128405_("Counter", this.counter);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyHandler.invalidate();
        this.items.invalidate();
    }

    public void setPlayersInside(int amt) {
        if (amt == this.playersInside) {
            return;
        }
        if (this.playersInside == 0 && amt > 0) {
            if (!this.f_58857_.f_46443_) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GrinderBlock.IS_OPEN, (Comparable)Boolean.valueOf(true)));
            }
            this.m_58904_().m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 0.25f, 0.5f, false);
        }
        this.playersInside = amt;
        if (this.playersInside == 0) {
            if (!this.f_58857_.f_46443_) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)GrinderBlock.IS_OPEN, (Comparable)Boolean.valueOf(false)));
            }
            this.m_58904_().m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 0.25f, 0.5f, false);
        }
    }

    public int getPlayersInside() {
        int amt = 0;
        float x = this.m_58899_().m_123341_();
        float y = this.m_58899_().m_123342_();
        float z = this.m_58899_().m_123343_();
        float distance = 5.0f;
        for (Player playerentity : this.f_58857_.m_45976_(Player.class, new AABB((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + 1.0f + distance), (double)(y + 1.0f + distance), (double)(z + 1.0f + distance)))) {
            if (!(playerentity.f_36096_ instanceof GrinderContainer) || ((GrinderContainer)playerentity.f_36096_).getBE().m_58899_() != this.m_58899_()) continue;
            ++amt;
        }
        return amt;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return this.hopper.cast();
            }
            return this.items.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public GrinderBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.GRINDER_BE.get(), pos, state);
    }

    private HempFarmerEnergyStorage createEnergyStorage() {
        return new HempFarmerEnergyStorage((Integer)GrinderConfig.ENERGY_CAPACITY.get(), (Integer)GrinderConfig.ENERGY_RECEIVE.get()){

            @Override
            protected void onEnergyChanged() {
                GrinderBE.this.m_6596_();
            }
        };
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }
}

