/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import com.girafi.passthroughsigns.api.IPassable;
import com.girafi.passthroughsigns.api.PassthroughSignsAPI;
import com.girafi.passthroughsigns.util.ConfigurationHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="passthroughsigns")
public class PassableHandler {
    public static final boolean IS_QUARK_LOADED = ModList.get().isLoaded("quark");

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Player player = event.getPlayer();
        Block block = state.m_60734_();
        if (block instanceof WallSignBlock && (Boolean)ConfigurationHandler.GENERAL.shouldWallSignBePassable.get() != false || block instanceof WallBannerBlock && (Boolean)ConfigurationHandler.GENERAL.shouldBannerBePassable.get() != false || block instanceof IPassable && ((IPassable)block).canBePassed(level, pos, IPassable.EnumPassableType.WALL_BLOCK) || PassthroughSignsAPI.BLOCK_PASSABLES.contains(block)) {
            Direction facingOpposite = Direction.NORTH.m_122424_();
            if (state.m_61138_((Property)DirectionalBlock.f_52588_)) {
                facingOpposite = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_();
            } else if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                facingOpposite = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
            }
            if (block instanceof WallSignBlock) {
                if (IS_QUARK_LOADED && player.m_6047_() && ((Boolean)ConfigurationHandler.GENERAL.shiftClickQuark.get()).booleanValue()) {
                    PassableHandler.rightClick(level, pos, player, event.getHand(), facingOpposite);
                } else if (!IS_QUARK_LOADED) {
                    PassableHandler.rightClick(level, pos, player, event.getHand(), facingOpposite);
                }
            } else if (!player.m_6047_()) {
                PassableHandler.rightClick(level, pos, player, event.getHand(), facingOpposite);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getWorld();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        Entity entity = event.getTarget();
        if (entity instanceof ItemFrame && (Boolean)ConfigurationHandler.GENERAL.shouldItemFrameBePassable.get() != false || entity instanceof Painting && (Boolean)ConfigurationHandler.GENERAL.shouldPaintingsBePassable.get() != false || entity instanceof IPassable && ((IPassable)entity).canBePassed(level, pos, IPassable.EnumPassableType.HANGING_ENTITY) || PassthroughSignsAPI.ENTITY_PASSABLES.contains(entity.m_6095_())) {
            Direction facingOpposite = entity.m_6350_().m_122424_();
            if (!player.m_6047_()) {
                if (entity instanceof ItemFrame && ((Boolean)ConfigurationHandler.GENERAL.turnOffItemRotation.get()).booleanValue() && level.m_8055_(pos.m_142300_(facingOpposite)).m_155947_()) {
                    event.setCanceled(true);
                }
                PassableHandler.rightClick(level, pos, player, event.getHand(), facingOpposite);
            }
        }
    }

    private static void rightClick(Level level, BlockPos pos, Player player, InteractionHand hand, Direction facingOpposite) {
        if (hand == InteractionHand.MAIN_HAND) {
            BlockPos posOffset = pos.m_142082_(facingOpposite.m_122429_(), facingOpposite.m_122430_(), facingOpposite.m_122431_());
            BlockState attachedState = level.m_8055_(posOffset);
            BlockState stateDown = level.m_8055_(pos.m_7495_());
            BlockHitResult rayTrace = new BlockHitResult(new Vec3((double)posOffset.m_123341_(), (double)posOffset.m_123342_(), (double)posOffset.m_123343_()), facingOpposite, pos, false);
            if (!level.m_46859_(pos.m_7495_()) && attachedState.m_60795_()) {
                stateDown.m_60734_().m_6227_(stateDown, level, pos.m_7495_(), player, hand, rayTrace);
            } else if (!attachedState.m_60795_()) {
                attachedState.m_60734_().m_6227_(attachedState, level, posOffset, player, hand, rayTrace);
            }
        }
    }
}

