/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.api.network.HandshakeMessage;
import com.mrcrayfish.framework.network.Network;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;

public class S2CLoginData
extends HandshakeMessage<S2CLoginData> {
    private ResourceLocation id;
    private FriendlyByteBuf data;

    public S2CLoginData() {
    }

    public S2CLoginData(ResourceLocation id, FriendlyByteBuf data) {
        this.id = id;
        this.data = data;
    }

    @Override
    public void encode(S2CLoginData message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        buffer.m_130130_(message.data.readableBytes());
        buffer.writeBytes((ByteBuf)message.data);
    }

    @Override
    public S2CLoginData decode(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        int readableBytes = buffer.m_130242_();
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.wrappedBuffer((ByteBuf)buffer.readBytes(readableBytes)));
        return new S2CLoginData(id, data);
    }

    @Override
    public void handle(S2CLoginData message, Supplier<NetworkEvent.Context> supplier) {
        String[] response = new String[1];
        CountDownLatch block = new CountDownLatch(1);
        supplier.get().enqueueWork(() -> {
            ILoginData data = Network.getLoginDataSupplier(message.id).get();
            data.readData(message.data).ifPresent(s -> {
                response[0] = s;
            });
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (response[0] != null) {
            String modName = ModList.get().getModContainerById(message.id.m_135827_()).map(container -> container.getModInfo().getDisplayName()).orElse("Framework");
            supplier.get().getNetworkManager().m_129507_((Component)new TextComponent("Connection closed - [" + modName + "] " + response[0]));
            return;
        }
        supplier.get().setPacketHandled(true);
        Network.getHandshakeChannel().reply((Object)new HandshakeMessage.Acknowledge(), supplier.get());
    }
}

