/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.icon.CustomIconItem;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.LazyIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Icon {
    private final ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        if (stack.m_41619_()) {
            return EMPTY;
        }
        if (stack.m_41720_() instanceof CustomIconItem) {
            return ((CustomIconItem)stack.m_41720_()).getCustomIcon(stack);
        }
        return new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return item == Items.f_41852_ ? EMPTY : ItemIcon.getItemIcon(item.m_7968_());
    }

    public static Icon getItemIcon(final String lazyStackString) {
        if (lazyStackString.isEmpty()) {
            return EMPTY;
        }
        return new LazyIcon(() -> {
            String[] s = lazyStackString.split(" ", 4);
            ItemStack stack = ((Item)Registry.f_122827_.m_7745_(new ResourceLocation(s[0]))).m_7968_();
            if (s.length >= 2 && !s[1].equals("1")) {
                stack.m_41764_(Integer.parseInt(s[1]));
            }
            if (s.length >= 3 && !s[2].equals("0")) {
                stack.m_41721_(Integer.parseInt(s[2]));
            }
            if (s.length >= 4 && !s[3].equals("null")) {
                try {
                    stack.m_41751_(TagParser.m_129359_((String)s[3]));
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Items.f_42127_);
                stack.m_41714_((Component)new TextComponent(lazyStackString));
            }
            return ItemIcon.getItemIcon(stack);
        }){

            @Override
            public String toString() {
                return "item:" + lazyStackString;
            }
        };
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack matrixStack, int x, int y, int w, int h) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
        if (w != 16 || h != 16) {
            int s = Math.min(w, h);
            matrixStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        GuiHelper.drawItem(matrixStack, this.getStack(), 0, true, null);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawStatic(PoseStack matrixStack, int x, int y, int w, int h) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
        if (w != 16 || h != 16) {
            int s = Math.min(w, h);
            matrixStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        GuiHelper.drawItem(matrixStack, this.getStack(), 0, false, null);
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItem3D(PoseStack matrixStack, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, 240, OverlayTexture.f_118083_, matrixStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw3D(PoseStack matrixStack) {
        ItemIcon.drawItem3D(matrixStack, this.getStack());
    }

    public String toString() {
        ItemStack is = this.getStack();
        StringBuilder builder = new StringBuilder("item:");
        builder.append(Registries.getId((Object)is.m_41720_(), (ResourceKey)Registry.f_122904_));
        int count = is.m_41613_();
        int damage = is.m_41773_();
        CompoundTag nbt = is.m_41783_();
        if (count > 1 || damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(damage);
        }
        if (nbt != null) {
            builder.append(' ');
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.m_41720_().hashCode();
        h = h * 31 + stack.m_41613_();
        h = h * 31 + Objects.hashCode(stack.m_41783_());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.m_41728_((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }
}

