/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static final String SELECT = "\u00a7";
    private static DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static BiMap<Block, Fluid> fluidBlocks = null;

    @Deprecated
    public static String formatNumber(double value) {
        if (Math.abs(value) < 1000.0) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000.0) {
            return Utils.addCommas((int)value);
        }
        if (Math.abs(value) < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (Math.abs(value) < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    @Deprecated
    public static String formatNumber(long value) {
        if (value == Long.MIN_VALUE) {
            value = Long.MAX_VALUE;
        }
        if (Math.abs(value) < 1000L) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000L) {
            return Utils.addCommas(value);
        }
        if (Math.abs(value) < 1000000000L) {
            return String.valueOf((double)Math.round(value / 100000L) / 10.0) + "M";
        }
        if (Math.abs(value) < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 100000000L) / 10.0) + "G";
        }
        if (Math.abs(value) < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (Math.abs(value) < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "P";
        }
        if (Math.abs(value) <= Long.MAX_VALUE) {
            return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "E";
        }
        return "Something is very broken!!!!";
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Deprecated
    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Utils.getDistance(x1, y1, z1, x2, y2, z2);
    }

    @Deprecated
    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistance(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static double getDistance(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistance(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static int getCardinalDistance(BlockPos pos1, BlockPos pos2) {
        int x = Math.abs(pos2.m_123341_() - pos1.m_123341_());
        int y = Math.abs(pos2.m_123342_() - pos1.m_123342_());
        int z = Math.abs(pos2.m_123343_() - pos1.m_123343_());
        return Math.max(Math.max(x, y), z);
    }

    public static boolean inRangeSphere(BlockPos posA, BlockPos posB, int range) {
        if (Math.abs(posA.m_123341_() - posB.m_123341_()) > range || Math.abs(posA.m_123342_() - posB.m_123342_()) > range || Math.abs(posA.m_123343_() - posB.m_123343_()) > range) {
            return false;
        }
        return Utils.getDistanceSq(posA.m_123341_(), posA.m_123342_(), posA.m_123343_(), posB.m_123341_(), posB.m_123342_(), posB.m_123343_()) <= (double)(range * range);
    }

    @Deprecated
    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistance(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static int determineOrientation(int x, int y, int z, LivingEntity entity) {
        int l;
        if (Mth.m_14154_((float)((float)entity.m_20185_() - (float)x)) < 2.0f && Mth.m_14154_((float)((float)entity.m_20189_() - (float)z)) < 2.0f) {
            double d0 = entity.m_20186_() + 1.82 - entity.m_6049_();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = Mth.m_14107_((double)((double)(entity.m_146908_() * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static int toInt(double d) {
        return (int)d;
    }

    public static int parseInt(String s) {
        return Utils.parseInt(s, true);
    }

    public static int parseInt(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0.0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s) {
        return Utils.parseDouble(s, true);
    }

    public static int parseHex(String s) {
        return Utils.parseHex(s, true);
    }

    public static int parseHex(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        if (catchException) {
            try {
                return (int)Long.parseLong(s, 16);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return (int)Long.parseLong(s, 16);
    }

    public static boolean validInteger(String value) {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, true);
    }

    @Nullable
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance, boolean includeCreative) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, includeCreative, false);
    }

    @Nullable
    @Deprecated
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance, boolean includeCreative, boolean includeSpectators) {
        double d0 = -1.0;
        Player closestPlayer = null;
        for (int i = 0; i < world.m_6907_().size(); ++i) {
            Player player = (Player)world.m_6907_().get(i);
            if (player.m_7500_() && !includeCreative || player.m_5833_() && !includeSpectators) continue;
            double d1 = player.m_20275_(posX, posY, posZ);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static boolean checkClassInstanceOf(Class clazz, Class instanceOfThis) {
        if (clazz == null || instanceOfThis == null) {
            return clazz == null && instanceOfThis == null;
        }
        return instanceOfThis.isAssignableFrom(clazz);
    }

    public static String trimString(String input, int length, String trimExtension) {
        if (input.length() <= length) {
            return input;
        }
        return input.substring(0, length) + trimExtension;
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String copyText) {
        if (!StringUtils.isEmpty((CharSequence)copyText)) {
            try {
                StringSelection stringselection = new StringSelection(copyText);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public static void openWebLink(URI url) {
        Util.m_137581_().m_137648_(url);
    }

    public static int parseColourRGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            String[] vals = value.split(",");
            if (vals.length != 3) {
                throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            return r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static int parseColourARGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            int b;
            String[] vals = value.split(",");
            if (vals.length < 3 || vals.length > 4) {
                throw new NumberFormatException("Number must be a hex using the format 0xAARRGGBB or #AARRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int n = b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            int a = vals.length == 4 ? (vals[3].contains(".") ? (int)(Double.parseDouble(vals[3]) * 255.0) : Integer.parseInt(vals[3])) : 255;
            return a << 24 | r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                Block fluidBlock = fluid.m_76145_().m_76188_().m_60734_();
                if (fluidBlock == Blocks.f_50016_) continue;
                tmp.put((Object)fluidBlock, (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static String getTextFormatString(String stringIn) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = -1;
        int j = stringIn.length();
        while ((i = stringIn.indexOf(167, i + 1)) != -1) {
            ChatFormatting textformatting;
            if (i >= j - 1 || (textformatting = ChatFormatting.m_126645_((char)stringIn.charAt(i + 1))) == null) continue;
            if (!textformatting.m_126661_()) {
                stringbuilder.setLength(0);
            }
            if (textformatting == ChatFormatting.RESET) continue;
            stringbuilder.append(textformatting);
        }
        return stringbuilder.toString();
    }

    @Deprecated
    public static boolean isAreaLoaded(Level world, BlockPos pos, ChunkHolder.FullChunkStatus minimum) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess ichunk = world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        if (!(ichunk instanceof LevelChunk)) {
            return false;
        }
        ChunkHolder.FullChunkStatus locationType = ((LevelChunk)ichunk).m_6708_();
        return locationType.m_140114_(minimum);
    }

    public static long safeAdd(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return Long.MAX_VALUE;
        }
        return r;
    }

    public static int scaleToTPS(Level world, int min, int max) {
        if (!(world instanceof ServerLevel)) {
            return max;
        }
        long[] times = world.m_142572_().getTickTime(world.m_46472_());
        if (times == null) {
            return max;
        }
        double worldTickTime = (double)Utils.mean(times) * 1.0E-6;
        double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
        return MathHelper.clip((int)((int)MathUtils.map(worldTPS, 5.0, 20.0, min, max)), (int)min, (int)max);
    }

    public static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static void hollowCube(BlockPos min, BlockPos max, Consumer<BlockPos> callback) {
        Utils.hollowCube(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_(), callback);
    }

    public static void hollowCube(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, Consumer<BlockPos> callback) {
        int y;
        if (xmax - xmin < 2 || ymax - ymin < 2 || zmax - zmin < 2) {
            Utils.betweenClosed(xmin, ymin, zmin, xmax, ymax, zmax, callback);
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = xmin; x <= xmax; ++x) {
            for (y = ymin + 1; y <= ymax - 1; ++y) {
                for (int z = zmin; z <= zmax; z += zmax - zmin) {
                    callback.accept((BlockPos)cursor.m_122178_(x, y, z));
                }
            }
            for (int z = zmin; z <= zmax; ++z) {
                for (int y2 = ymin; y2 <= ymax; y2 += ymax - ymin) {
                    callback.accept((BlockPos)cursor.m_122178_(x, y2, z));
                }
            }
        }
        for (int z = zmin + 1; z <= zmax - 1; ++z) {
            for (y = ymin + 1; y <= ymax - 1; ++y) {
                for (int x = xmin; x <= xmax; x += xmax - xmin) {
                    callback.accept((BlockPos)cursor.m_122178_(x, y, z));
                }
            }
        }
    }

    public static void betweenClosed(BlockPos min, BlockPos max, Consumer<BlockPos> callback) {
        Utils.betweenClosed(Math.min(min.m_123341_(), max.m_123341_()), Math.min(min.m_123342_(), max.m_123342_()), Math.min(min.m_123343_(), max.m_123343_()), Math.max(min.m_123341_(), max.m_123341_()), Math.max(min.m_123342_(), max.m_123342_()), Math.max(min.m_123343_(), max.m_123343_()), callback);
    }

    public static void betweenClosed(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, Consumer<BlockPos> callback) {
        int width = xmax - xmin + 1;
        int height = ymax - ymin + 1;
        int depth = zmax - zmin + 1;
        int total = width * height * depth;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int index = 0; index < total; ++index) {
            int x = index % width;
            int j1 = index / width;
            int y = j1 % height;
            int z = j1 / height;
            callback.accept((BlockPos)cursor.m_122178_(xmin + x, ymin + y, zmin + z));
        }
    }
}

