/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.functions.TriPredicate;
import com.brandon3055.brandonscore.utils.DataUtils;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public static boolean hasStack(ItemStack stack, Container inventory) {
        if (stack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack s = inventory.m_8020_(i);
            if (!ItemStack.m_41746_((ItemStack)stack, (ItemStack)s) || stack.m_41773_() != s.m_41773_() || s.m_41613_() < stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeStack(ItemStack stack, Container inventory) {
        if (stack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack s = inventory.m_8020_(i);
            if (s.m_41619_() || !ItemStack.m_41746_((ItemStack)stack, (ItemStack)s) || stack.m_41773_() != s.m_41773_() || s.m_41613_() < stack.m_41613_()) continue;
            s.m_41774_(stack.m_41613_());
            inventory.m_6596_();
            return true;
        }
        return false;
    }

    public static void handleHeldStackTransfer(int slot, Container inventory, Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (!inventory.m_8020_(slot).m_41619_()) {
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, inventory.m_8020_(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.m_8020_(slot));
            }
            inventory.m_6836_(slot, ItemStack.f_41583_);
        } else {
            DataUtils.forEach(InteractionHand.values(), enumHand -> {
                ItemStack stack = player.m_21120_(enumHand);
                if (!stack.m_41619_() && inventory.m_7013_(slot, stack) && inventory.m_8020_(slot).m_41619_()) {
                    inventory.m_6836_(slot, stack);
                    player.m_21008_(enumHand, ItemStack.f_41583_);
                }
            });
        }
    }

    public static void handleHeldStackTransfer(int slot, IItemHandlerModifiable inventory, Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (!inventory.getStackInSlot(slot).m_41619_()) {
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, inventory.getStackInSlot(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.getStackInSlot(slot));
            }
            inventory.setStackInSlot(slot, ItemStack.f_41583_);
        } else {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41619_() || !inventory.isItemValid(slot, stack)) continue;
                inventory.setStackInSlot(slot, stack);
                player.m_21008_(hand, ItemStack.f_41583_);
                return;
            }
        }
    }

    public static void consumeHeldItem(Player player, ItemStack stack, InteractionHand hand) {
        stack.m_41774_(1);
        player.m_21008_(hand, stack.m_41613_() > 0 ? stack.m_41777_() : ItemStack.f_41583_);
    }

    public static void givePlayerStack(Player player, ItemStack stack) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            return;
        }
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            InventoryUtils.dropItemNoDelay(stack, player.f_19853_, Vector3.fromEntity((Entity)player));
        }
    }

    public static void dropItemNoDelay(ItemStack stack, Level world, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.m_20334_(world.f_46441_.nextGaussian() * 0.05, world.f_46441_.nextGaussian() * 0.05 + (double)0.2f, world.f_46441_.nextGaussian() * 0.05);
        world.m_7967_((Entity)item);
        item.m_32061_();
    }

    public static int findMatchingStack(IItemHandler itemHandler, TriPredicate<IItemHandler, ItemStack, Integer> predicate) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!predicate.test(itemHandler, itemHandler.getStackInSlot(i), i)) continue;
            return i;
        }
        return -1;
    }
}

