/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.gui.GuiPlayerAccess;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import com.mojang.math.Vector3f;
import java.util.UUID;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, ClientPacketListener handler) {
        switch (packet.getType()) {
            case 1: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
                if (!(blockEntity instanceof IDataManagerProvider)) break;
                IDataManagerProvider tile = (IDataManagerProvider)blockEntity;
                tile.getDataManager().receiveSyncData((MCDataInput)packet);
                break;
            }
            case 2: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
                if (!(blockEntity instanceof TileBCore)) break;
                TileBCore tile = (TileBCore)blockEntity;
                int id = packet.readByte() & 0xFF;
                tile.receivePacketFromServer((MCDataInput)packet, id);
                break;
            }
            case 4: {
                boolean enable = packet.readBoolean();
                if (enable) {
                    BCEventHandler.noClipPlayers.add(mc.f_91074_.m_142081_());
                    break;
                }
                BCEventHandler.noClipPlayers.remove(mc.f_91074_.m_142081_());
                break;
            }
            case 6: {
                GuiPlayerAccess gui;
                GuiPlayerAccess guiPlayerAccess = gui = mc.f_91080_ instanceof GuiPlayerAccess ? (GuiPlayerAccess)mc.f_91080_ : null;
                if (gui == null) break;
                gui.name = packet.readString();
                gui.pos = packet.readPos();
                gui.dimension = packet.readInt();
                break;
            }
            case 7: {
                BrandonsCore.proxy.sendIndexedMessage((Player)mc.f_91074_, (Component)packet.readTextComponent(), packet.readInt());
                break;
            }
            case 8: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
                if (!(blockEntity instanceof TileBCore)) break;
                TileBCore tile = (TileBCore)blockEntity;
                tile.getCapManager().receiveCapSyncData((MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handlePlaySound(packet, mc);
                break;
            }
            case 10: {
                ClientPacketHandler.handleEntitySpawn(packet, mc);
                break;
            }
            case 11: {
                ClientPacketHandler.handleParticleSpawn(packet, mc);
                break;
            }
            case 12: {
                ClientPacketHandler.handleEntityVelocity(packet, mc);
                break;
            }
            case 13: {
                mc.m_91152_((Screen)new HudConfigGui());
                break;
            }
            case 14: {
                MultiBlockManager.receiveDefinitionsFromServer(packet);
                break;
            }
            case 15: {
                ContributorHandler.handleSettingsFromServer(packet);
            }
        }
    }

    private static void handlePlaySound(PacketCustom packet, Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        BlockPos pos = packet.readPos();
        SoundEvent sound = (SoundEvent)packet.readRegistryId();
        SoundSource category = SoundSource.values()[packet.readVarInt()];
        float volume = packet.readFloat();
        float pitch = packet.readFloat();
        boolean distanceDelay = packet.readBoolean();
        mc.f_91073_.m_104677_(pos, sound, category, volume, pitch, distanceDelay);
    }

    private static void handleEntitySpawn(PacketCustom packet, Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        EntityType type = (EntityType)Registry.f_122826_.m_7942_(packet.readVarInt());
        int entityID = packet.readInt();
        UUID uuid = packet.readUUID();
        double posX = packet.readDouble();
        double posY = packet.readDouble();
        double posZ = packet.readDouble();
        byte yaw = packet.readByte();
        byte pitch = packet.readByte();
        byte headYaw = packet.readByte();
        Vec3 velocity = new Vec3((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat());
        Entity entity = type.m_20615_((Level)mc.f_91073_);
        if (entity == null) {
            return;
        }
        entity.m_20167_(posX, posY, posZ);
        entity.m_19890_(posX, posY, posZ, (float)(pitch * 360) / 256.0f, (float)(yaw * 360) / 256.0f);
        entity.m_5616_((float)(headYaw * 360) / 256.0f);
        entity.m_5618_((float)(headYaw * 360) / 256.0f);
        entity.m_20234_(entityID);
        entity.m_20084_(uuid);
        mc.f_91073_.m_104627_(entityID, entity);
        entity.m_6001_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
    }

    private static void handleEntityVelocity(PacketCustom packet, Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        int entityID = packet.readInt();
        Entity entity = mc.f_91073_.m_6815_(entityID);
        if (entity != null) {
            Vector3f motion = packet.readVec3f();
            entity.m_6001_((double)motion.m_122239_(), (double)motion.m_122260_(), (double)motion.m_122269_());
            if (packet.readBoolean()) {
                entity.m_146926_(packet.readFloat());
                entity.m_146922_(packet.readFloat());
                entity.m_6853_(packet.readBoolean());
            }
        }
    }

    private static void handleParticleSpawn(PacketCustom packet, Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        ParticleType type = (ParticleType)packet.readRegistryId();
        ParticleOptions data = type.m_123743_().m_6507_((ParticleType)SneakyUtils.unsafeCast((Object)type), packet.toPacketBuffer());
        Vector3 pos = packet.readVector();
        Vector3 motion = packet.readVector();
        boolean distanceOverride = packet.readBoolean();
        mc.f_91073_.m_6493_(data, distanceOverride, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }
}

