/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;

public class FilterTamed
extends FilterBase {
    protected boolean whitelistTamed = true;
    protected boolean includeTamable = true;

    public FilterTamed(EntityFilter filter) {
        super(filter);
    }

    public void setIncludeTamable(boolean includeTamable) {
        boolean prev = this.includeTamable;
        this.includeTamable = includeTamable;
        this.getFilter().nodeModified(this);
        this.includeTamable = prev;
    }

    public void setWhitelistTamed(boolean whitelistTamed) {
        boolean prev = this.whitelistTamed;
        this.whitelistTamed = whitelistTamed;
        this.getFilter().nodeModified(this);
        this.whitelistTamed = prev;
    }

    public boolean isIncludeTamable() {
        return this.includeTamable;
    }

    public boolean isWhitelistTamed() {
        return this.whitelistTamed;
    }

    @Override
    public boolean test(Entity entity) {
        boolean isTamable = entity instanceof TamableAnimal;
        if (isTamable) {
            TamableAnimal ownable = (TamableAnimal)entity;
            if (ownable.m_142504_() != null) {
                return this.whitelistTamed;
            }
            return this.includeTamable;
        }
        return !this.whitelistTamed;
    }

    @Override
    public FilterType getType() {
        return FilterType.TAMED;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("include", this.whitelistTamed);
        compound.m_128379_("tamable", this.includeTamable);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.whitelistTamed = nbt.m_128471_("include");
        this.includeTamable = nbt.m_128471_("tamable");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistTamed);
        output.writeBoolean(this.includeTamable);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistTamed = input.readBoolean();
        this.includeTamable = input.readBoolean();
    }
}

