/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class FilterItem
extends FilterBase {
    protected boolean whitelistItem = true;
    protected String itemName = "";
    protected int count = 0;
    protected int damage = -1;
    protected CompoundTag nbt = null;
    protected boolean filterBlocks = false;
    protected boolean filterItems = false;
    public boolean dataChanged = false;

    public FilterItem(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistItem(boolean whitelistItem) {
        boolean prev = this.whitelistItem;
        this.whitelistItem = whitelistItem;
        this.getFilter().nodeModified(this);
        this.whitelistItem = prev;
    }

    public boolean isWhitelistItem() {
        return this.whitelistItem;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
        this.getFilter().nodeModified(this);
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setCount(int count) {
        this.count = count;
        this.getFilter().nodeModified(this);
    }

    public int getCount() {
        return this.count;
    }

    public void setDamage(int damage) {
        this.damage = damage;
        this.getFilter().nodeModified(this);
    }

    public int getDamage() {
        return this.damage;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
        if (nbt != null && nbt.m_128456_()) {
            this.nbt = null;
        }
        this.getFilter().nodeModified(this);
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean isFilterBlocks() {
        return this.filterBlocks;
    }

    public void setFilterItemsBlocks(boolean filterItems, boolean filterBlocks) {
        boolean prev = this.filterItems;
        boolean prevBlocks = this.filterBlocks;
        this.filterItems = filterItems;
        this.filterBlocks = filterBlocks;
        this.getFilter().nodeModified(this);
        this.filterItems = prev;
        this.filterBlocks = prevBlocks;
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    @Override
    public boolean test(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            if (stack.m_41619_()) {
                return !this.whitelistItem;
            }
            boolean match = true;
            if (!this.itemName.isEmpty() && this.itemName.contains(":")) {
                String name = Objects.requireNonNull(stack.m_41720_().getRegistryName()).toString();
                match = name.equals(this.itemName);
            }
            if (match && this.count > 0) {
                boolean bl = match = stack.m_41613_() == this.count;
            }
            if (match && this.damage != -1) {
                boolean bl = match = stack.m_41773_() == this.damage;
            }
            if (match && this.nbt != null) {
                match = this.nbt.equals((Object)stack.m_41783_());
            }
            if (this.itemName.isEmpty()) {
                if (this.filterBlocks) {
                    match = stack.m_41720_() instanceof BlockItem;
                } else if (this.filterItems) {
                    match = !(stack.m_41720_() instanceof BlockItem);
                }
            }
            return match == this.whitelistItem;
        }
        return !this.whitelistItem;
    }

    @Override
    public FilterType getType() {
        return FilterType.ITEM_FILTER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("include", this.whitelistItem);
        compound.m_128359_("name", this.itemName);
        compound.m_128376_("count", (short)this.count);
        compound.m_128376_("damage", (short)this.count);
        compound.m_128379_("items", this.filterItems);
        compound.m_128379_("blocks", this.filterBlocks);
        if (this.nbt != null) {
            compound.m_128365_("nbt", (Tag)this.nbt);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.whitelistItem = compound.m_128471_("include");
        this.itemName = compound.m_128461_("name");
        this.count = compound.m_128448_("count");
        this.damage = compound.m_128448_("damage");
        this.filterItems = compound.m_128471_("items");
        this.filterBlocks = compound.m_128471_("blocks");
        this.nbt = null;
        if (compound.m_128425_("nbt", 10)) {
            this.nbt = compound.m_128469_("nbt");
        }
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistItem);
        output.writeString(this.itemName);
        output.writeVarInt(this.count);
        output.writeVarInt(this.damage);
        output.writeBoolean(this.filterItems);
        output.writeBoolean(this.filterBlocks);
        output.writeCompoundNBT(this.nbt);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistItem = input.readBoolean();
        this.itemName = input.readString();
        this.count = input.readVarInt();
        this.damage = input.readVarInt();
        this.filterItems = input.readBoolean();
        this.filterBlocks = input.readBoolean();
        this.nbt = input.readCompoundNBT();
        this.dataChanged = true;
    }
}

