/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public class ThreadedImageDownloader
extends SimpleTexture {
    private static final Logger LOGGER = LogHelperBC.logger;
    private DLResourceLocation dlLocation = null;
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public ThreadedImageDownloader(File cacheFile, String imageUrl, DLResourceLocation textureLocation) {
        super((ResourceLocation)textureLocation);
        this.cacheFile = cacheFile;
        this.imageUrl = imageUrl;
    }

    public void setDlLocation(DLResourceLocation dlLocation) {
        this.dlLocation = dlLocation;
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.m_85283_((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
    }

    private void setImage(NativeImage nativeImageIn) {
        Minecraft.m_91087_().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.m_69586_()) {
                RenderSystem.m_69879_(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
        this.dlLocation.width = nativeImageIn.m_84982_();
        this.dlLocation.height = nativeImageIn.m_85084_();
        this.dlLocation.sizeSet = true;
        this.dlLocation.dlFailed = false;
        this.dlLocation.dlFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6704_(ResourceManager manager) throws IOException {
        if (!this.textureUploaded) {
            ThreadedImageDownloader threadedImageDownloader = this;
            synchronized (threadedImageDownloader) {
                super.m_6704_(manager);
                this.textureUploaded = true;
            }
        }
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = FileHandler.openConnection(this.imageUrl, Minecraft.m_91087_().m_91096_());
                        httpurlconnection.connect();
                        int responseCode = httpurlconnection.getResponseCode();
                        if (responseCode / 100 == 2) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.m_91087_().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            return;
                        }
                        this.dlLocation.dlFinished = true;
                        this.dlLocation.dlFailed = true;
                    }
                    catch (Throwable exception) {
                        LOGGER.error("Couldn't download http texture", exception);
                        this.dlLocation.dlFinished = true;
                        this.dlLocation.dlFailed = true;
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.m_183991_());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)inputStreamIn);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }
}

