/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, Entity destination) {
        return TeleportUtils.teleportEntity(entity, (ResourceKey<Level>)destination.f_19853_.m_46472_(), destination.m_20185_(), destination.m_20186_(), destination.f_19792_, destination.m_146908_(), destination.m_146909_());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.f_19853_.f_46443_) {
            return entity;
        }
        MinecraftServer server = entity.m_20194_();
        ResourceKey sourceDim = entity.f_19853_.m_46472_();
        if (!entity.m_20160_() && !entity.m_20159_()) {
            return TeleportUtils.handleEntityTeleport(entity, server, (ResourceKey<Level>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.m_20201_();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            LogHelperBC.error("RiddenEntity: This error should not be possible");
            return entity;
        }
        passengerHelper.teleport(server, (ResourceKey<Level>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, Vector3 pos, float yaw, float pitch) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, yaw, pitch);
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.m_146908_(), entity.m_146909_());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, Vector3 pos) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, entity.m_146908_(), entity.m_146909_());
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, ResourceKey<Level> sourceDim, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.f_19853_.f_46443_ || targetDim == null) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, sourceDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof ServerPlayer) {
                return TeleportUtils.teleportPlayerInterdimentional((ServerPlayer)entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtils.teleportEntityInterdimentional(entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8906_.m_9774_(xCoord, yCoord, zCoord, yaw, pitch);
            player.m_5616_(yaw);
        } else {
            entity.m_7678_(xCoord, yCoord, zCoord, yaw, pitch);
            entity.m_5616_(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerLevel targetWorld = server.m_129880_(targetDim);
        if (!entity.m_6084_() || targetWorld == null) {
            return null;
        }
        Entity movedEntity = entity.m_5489_(targetWorld);
        if (movedEntity != null) {
            movedEntity.m_7678_(xCoord, yCoord, zCoord, yaw, pitch);
            return movedEntity;
        }
        entity.m_19877_();
        movedEntity = entity.m_6095_().m_20615_((Level)targetWorld);
        if (movedEntity != null) {
            movedEntity.m_20361_(entity);
            movedEntity.m_7678_(xCoord, yCoord, zCoord, yaw, pitch);
            targetWorld.m_143334_(movedEntity);
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            ((ServerLevel)entity.f_19853_).m_8886_();
            targetWorld.m_8886_();
            return movedEntity;
        }
        return entity;
    }

    private static Player teleportPlayerInterdimentional(ServerPlayer player, MinecraftServer server, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerLevel originWorld = player.m_183503_();
        ServerLevel targetWorld = server.m_129880_(targetDim);
        if (!player.m_6084_() || targetWorld == null) {
            return player;
        }
        player.f_8927_ = true;
        player.m_8999_(targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
        player.f_8920_ = -1;
        player.f_8917_ = -1.0f;
        player.f_8918_ = -1;
        player.m_6885_();
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.m_20197_().size() > 0) {
            entity = (Entity)entity.m_20197_().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.m_20159_()) {
                this.offsetX = entity.m_20185_() - entity.m_20202_().m_20185_();
                this.offsetY = entity.m_20186_() - entity.m_20202_().m_20186_();
                this.offsetZ = entity.m_20189_() - entity.m_20202_().m_20189_();
            }
            for (Entity passenger : entity.m_20197_()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, ResourceKey<Level> sourceDim, ResourceKey<Level> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.m_20153_();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.m_20159_()) {
                this.entity.m_7678_(this.entity.m_20185_() + this.offsetX, this.entity.m_20186_() + this.offsetY, this.entity.m_20189_() + this.offsetZ, this.entity.m_146908_(), this.entity.m_146909_());
            }
            for (PassengerHelper passenger : this.passengers) {
                DelayedTask.run(1, () -> passenger.entity.m_7998_(this.entity, true));
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayer) {
                this.updateClient((ServerPlayer)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayer playerMP) {
            if (this.entity.m_20160_()) {
                playerMP.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

