/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringyStacks {
    public static final Logger LOGGER = LogManager.getLogger((String)"StackConverter");

    public static ItemStack fromString(String stackString) {
        return StringyStacks.fromString(stackString, ItemStack.f_41583_);
    }

    public static ItemStack fromString(String stackString, @Nullable ItemStack defaultIfInputInvalid) {
        ItemStack stack;
        if (stackString.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (!stackString.contains(":")) {
            LOGGER.warn("StackReference: Was given an invalid stack string. String did not contain \":\" - " + stackString);
            return defaultIfInputInvalid;
        }
        if (stackString.contains("{") && stackString.contains(",") && stackString.indexOf(",") < stackString.indexOf("{")) {
            try {
                return StringyStacks.legacyFromString(stackString, defaultIfInputInvalid);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse legacy stack string - " + stackString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        String stackStr = stackString;
        String itemID = stackStr.contains("{") ? stackStr.substring(0, stackStr.indexOf("{")) : (stackStr.contains(",") ? stackStr.substring(0, stackStr.indexOf(",")) : stackStr);
        stackStr = stackString.substring(itemID.length());
        CompoundTag tagNBT = null;
        if (stackStr.startsWith("{")) {
            if (!stackString.contains("}") || stackStr.lastIndexOf("}") < stackString.indexOf("{")) {
                LOGGER.warn("Detected invalid NBT definition on stack string - " + stackString);
                return defaultIfInputInvalid;
            }
            String tag = stackStr.substring(0, stackStr.lastIndexOf("}") + 1);
            try {
                tagNBT = TagParser.m_129359_((String)tag);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + tag + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
            stackStr = stackString.substring(tag.length());
        }
        int count = 1;
        if (stackStr.startsWith(",") && stackString.length() > 1) {
            try {
                count = Integer.parseInt(stackStr.substring(1));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + stackStr + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        CompoundTag stackNBT = new CompoundTag();
        stackNBT.m_128359_("id", itemID);
        stackNBT.m_128344_("Count", (byte)count);
        if (tagNBT != null && !tagNBT.m_128456_()) {
            if (tagNBT.m_128440_() == 2 && tagNBT.m_128425_("tag", 10) && tagNBT.m_128441_("ForgeCaps")) {
                CompoundTag caps;
                CompoundTag tag = tagNBT.m_128469_("tag");
                if (!tag.m_128456_()) {
                    stackNBT.m_128365_("tag", (Tag)tag);
                }
                if (!(caps = tagNBT.m_128469_("ForgeCaps")).m_128456_()) {
                    stackNBT.m_128365_("ForgeCaps", (Tag)caps);
                }
            } else {
                stackNBT.m_128365_("tag", (Tag)tagNBT);
            }
        }
        if ((stack = ItemStack.m_41712_((CompoundTag)stackNBT)) == ItemStack.f_41583_) {
            return defaultIfInputInvalid;
        }
        return stack;
    }

    private static ItemStack legacyFromString(String string, @Nullable ItemStack defaultIfInputInvalid) {
        String stackString;
        String workString = string;
        String splitter = ",";
        String countString = "";
        String metaString = "";
        String nbt = "";
        if (!workString.contains(splitter)) {
            stackString = workString;
            workString = "";
        } else {
            stackString = workString.substring(0, workString.indexOf(splitter));
            workString = workString.substring(workString.indexOf(splitter) + splitter.length());
        }
        if (!workString.isEmpty()) {
            if (!workString.contains(splitter)) {
                countString = workString;
                workString = "";
            } else {
                countString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (!workString.isEmpty()) {
            if (!workString.contains(splitter)) {
                metaString = workString;
                workString = "";
            } else {
                metaString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (!workString.isEmpty()) {
            nbt = workString;
        }
        int count = 1;
        int meta = 0;
        CompoundTag compound = null;
        if (!countString.isEmpty()) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + countString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (!metaString.isEmpty()) {
            try {
                meta = Integer.parseInt(metaString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack meta from string - " + metaString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (!nbt.isEmpty()) {
            try {
                compound = TagParser.m_129359_((String)nbt);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + nbt + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        ResourceLocation registryName = new ResourceLocation(stackString);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
        if (item == null && block == Blocks.f_50016_) {
            return defaultIfInputInvalid;
        }
        ItemStack itemStack = item != null ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)block, count);
        itemStack.m_41721_(meta);
        if (compound != null) {
            itemStack.m_41751_(compound);
        }
        return itemStack;
    }

    public static String toString(ItemStack stack, boolean withNBT, boolean withCount, boolean withForgeCaps) {
        if (stack.m_41619_()) {
            return "";
        }
        Object stackString = stack.m_41720_().getRegistryName().toString();
        if (withNBT || withForgeCaps) {
            CompoundTag stackTag = stack.serializeNBT();
            CompoundTag nbt = null;
            CompoundTag caps = null;
            if (withNBT && stackTag.m_128425_("tag", 10)) {
                nbt = stackTag.m_128469_("tag");
            }
            if (withForgeCaps && stackTag.m_128441_("ForgeCaps")) {
                caps = stackTag.m_128469_("ForgeCaps");
            }
            CompoundTag stringTag = null;
            if (nbt != null && caps == null) {
                stringTag = nbt;
            } else if (caps != null) {
                stringTag = new CompoundTag();
                stringTag.m_128365_("ForgeCaps", (Tag)caps);
                stringTag.m_128365_("tag", (Tag)(nbt == null ? new CompoundTag() : nbt));
            }
            if (stringTag != null && !stringTag.m_128456_()) {
                stackString = (String)stackString + stringTag.toString();
            }
        }
        if (withCount && stack.m_41613_() > 1) {
            stackString = (String)stackString + "," + stack.m_41613_();
        }
        return stackString;
    }

    public static String toStringNoCaps(ItemStack stack) {
        return StringyStacks.toString(stack, true, true, false);
    }

    public static String toString(ItemStack stack) {
        return StringyStacks.toString(stack, true, true, true);
    }

    @Deprecated
    public static ItemStack legacyStackConverter(String itemString, int count, int damage, @Nullable CompoundTag nbt) {
        try {
            ResourceLocation itemID = new ResourceLocation(itemString);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemID);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(itemID);
            if (item == null && block == Blocks.f_50016_) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = item != null ? new ItemStack((ItemLike)item, count) : new ItemStack((ItemLike)block, count);
            itemStack.m_41721_(damage);
            if (nbt != null) {
                itemStack.m_41751_(nbt.m_6426_());
            }
            return itemStack;
        }
        catch (Throwable e) {
            return ItemStack.f_41583_;
        }
    }
}

