/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventorySimple;
import com.brandon3055.brandonscore.BCContent;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerPlayerAccess
extends AbstractContainerMenu {
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public Player player;
    public Player playerAccess;
    private Container targetInventory;
    private MinecraftServer server;
    private int tick = 0;

    public ContainerPlayerAccess(int id, Inventory playerInv) {
        super(BCContent.containerPlayerAccess, id);
        this.player = playerInv.f_35978_;
        this.playerAccess = null;
        this.targetInventory = new InventorySimple(41);
        this.layoutSlots();
    }

    public ContainerPlayerAccess(int id, Inventory playerInv, Player playerAccess, MinecraftServer server) {
        super(BCContent.containerPlayerAccess, id);
        this.player = playerInv.f_35978_;
        this.playerAccess = playerAccess;
        this.targetInventory = playerAccess.m_150109_();
        this.server = server;
        this.layoutSlots();
    }

    public void m_38946_() {
        if (this.tick++ % 10 == 0 && this.player instanceof ServerPlayer && this.playerAccess != null) {
            BCoreNetwork.sendPlayerAccessUIUpdate((ServerPlayer)this.player, this.playerAccess);
        }
        super.m_38946_();
    }

    public void layoutSlots() {
        int i;
        int x;
        int y;
        int x2;
        int xPos = 9;
        int yPos = 21;
        for (x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot(this.targetInventory, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot(this.targetInventory, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.m_38897_(new ArmorSlot(this.targetInventory, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.m_38897_(new OffhandSlot(this.targetInventory, 40, xPos + 186, yPos + 54 + 3));
        xPos = 9;
        yPos = 168;
        for (x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.m_38897_(new ArmorSlot((Container)this.player.m_150109_(), 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.m_38897_(new OffhandSlot((Container)this.player.m_150109_(), 40, xPos + 186, yPos + 54 + 3));
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    private static class ArmorSlot
    extends Slot {
        private final EquipmentSlot eSlot;
        private final Player aPlayer;

        public ArmorSlot(Container inventoryIn, int index, int xPosition, int yPosition, EquipmentSlot eSlot, Player aPlayer) {
            super(inventoryIn, index, xPosition, yPosition);
            this.eSlot = eSlot;
            this.aPlayer = aPlayer;
        }

        public int m_6641_() {
            return 64;
        }

        public boolean m_5857_(ItemStack stack) {
            return true;
        }

        public boolean m_8010_(Player playerIn) {
            ItemStack itemstack = this.m_7993_();
            return (itemstack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(playerIn);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return InventoryMenu.f_39696_.toString();
        }
    }

    private static class OffhandSlot
    extends Slot {
        public OffhandSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return "minecraft:items/empty_armor_slot_shield";
        }
    }
}

