/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ContainerBCore<D>
extends AbstractContainerMenu {
    protected Player player;
    protected ContainerSlotLayout.LayoutFactory<D> factory;
    protected ContainerSlotLayout slotLayout;

    public ContainerBCore(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super(type, windowId);
        this.player = playerInv.f_35978_;
    }

    public ContainerBCore(@Nullable MenuType<?> type, int windowId, Inventory player, FriendlyByteBuf extraData, ContainerSlotLayout.LayoutFactory<D> factory) {
        this(type, windowId, player, extraData);
        this.factory = factory;
        this.buildSlotLayout();
    }

    public ContainerBCore(@Nullable MenuType<?> type, int windowId, Inventory player) {
        super(type, windowId);
        this.player = player.f_35978_;
    }

    public ContainerBCore(@Nullable MenuType<?> type, int windowId, Inventory player, ContainerSlotLayout.LayoutFactory<D> factory) {
        this(type, windowId, player);
        this.player = player.f_35978_;
        this.factory = factory;
        this.buildSlotLayout();
    }

    protected void buildSlotLayout() {
        this.slotLayout = this.factory.buildLayout(this.player, null).retrieveSlotsForContainer(x$0 -> this.m_38897_((Slot)x$0));
    }

    public ContainerBCore addPlayerSlots(int posX, int posY) {
        return this.addPlayerSlots(posX, posY, 4);
    }

    public ContainerBCore addPlayerSlots(int posX, int posY, int hotbarSpacing) {
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new SlotCheckValid.IInv((Container)this.player.m_150109_(), x, posX + 18 * x, posY + 54 + hotbarSpacing));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new SlotCheckValid.IInv((Container)this.player.m_150109_(), x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
        return this;
    }

    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player player, int i) {
        LazyOptional<IItemHandler> optional;
        int playerSlots = 36;
        if (this.slotLayout != null) {
            playerSlots = this.slotLayout.getPlayerSlotCount();
        }
        if ((optional = this.getItemHandler()).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse((Object)EmptyHandler.INSTANCE);
            Slot slot = this.m_38853_(i);
            if (slot != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                ItemStack result = stack.m_41777_();
                if (i >= playerSlots ? !this.m_38903_(stack, 0, playerSlots, false) : !this.m_38903_(stack, playerSlots, playerSlots + handler.getSlots(), false)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41613_() == 0) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                slot.m_142406_(player, stack);
                return result;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        Slot slot = this.m_38853_(slotID);
        if (slot != null) {
            slot.m_5852_(stack);
        }
        this.f_182405_ = stateId;
    }

    public Slot m_38853_(int slotId) {
        if (slotId < this.f_38839_.size() && slotId >= 0) {
            return (Slot)this.f_38839_.get(slotId);
        }
        return null;
    }

    public void m_182410_(int stateId, List<ItemStack> stacks, ItemStack carried) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.m_38853_(i);
            if (slot == null) continue;
            slot.m_5852_(stacks.get(i));
        }
        this.f_150393_ = carried;
        this.f_182405_ = stateId;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return LazyOptional.empty();
    }

    public ContainerSlotLayout getSlotLayout() {
        return this.slotLayout;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
    }
}

